/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.proxy.request;

import io.wttech.markuply.engine.pipeline.http.proxy.configuration.HeaderProxyConfiguration;
import io.wttech.markuply.engine.pipeline.http.proxy.configuration.StaticHeaderConfiguration;
import io.wttech.markuply.engine.pipeline.http.proxy.request.HttpPageRequest;
import io.wttech.markuply.engine.pipeline.http.proxy.request.ReactiveRequestEnricher;
import java.util.List;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.filter.reactive.ServerWebExchangeContextFilter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class PageRequestConfigurableEnricher
implements ReactiveRequestEnricher {
    private final HeaderProxyConfiguration headerProxyConfiguration;
    private final StaticHeaderConfiguration staticHeaderConfiguration;

    @Override
    public Mono<HttpPageRequest.Builder> enrich(HttpPageRequest.Builder builder) {
        return Mono.deferContextual(Mono::just).map(this::extractFromRequest);
    }

    private HttpPageRequest.Builder extractFromRequest(ContextView monoContext) {
        ServerHttpRequest request = ((ServerWebExchange)monoContext.get((Object)ServerWebExchangeContextFilter.EXCHANGE_CONTEXT_ATTRIBUTE)).getRequest();
        HttpPageRequest.Builder builder = HttpPageRequest.builder();
        request.getHeaders().entrySet().stream().filter(entry -> this.headerProxyConfiguration.isAllowed((String)entry.getKey())).forEach(entry -> builder.addHeader((String)entry.getKey(), (List)entry.getValue()));
        this.staticHeaderConfiguration.getStaticHeaders().entrySet().forEach(entry -> builder.addHeader((String)entry.getKey(), (List)entry.getValue()));
        return builder;
    }

    private static HeaderProxyConfiguration $default$headerProxyConfiguration() {
        return HeaderProxyConfiguration.EMPTY;
    }

    private static StaticHeaderConfiguration $default$staticHeaderConfiguration() {
        return StaticHeaderConfiguration.EMPTY;
    }

    PageRequestConfigurableEnricher(HeaderProxyConfiguration headerProxyConfiguration, StaticHeaderConfiguration staticHeaderConfiguration) {
        this.headerProxyConfiguration = headerProxyConfiguration;
        this.staticHeaderConfiguration = staticHeaderConfiguration;
    }

    public static PageRequestConfigurableEnricherBuilder builder() {
        return new PageRequestConfigurableEnricherBuilder();
    }

    public static class PageRequestConfigurableEnricherBuilder {
        private boolean headerProxyConfiguration$set;
        private HeaderProxyConfiguration headerProxyConfiguration$value;
        private boolean staticHeaderConfiguration$set;
        private StaticHeaderConfiguration staticHeaderConfiguration$value;

        PageRequestConfigurableEnricherBuilder() {
        }

        public PageRequestConfigurableEnricherBuilder headerProxyConfiguration(HeaderProxyConfiguration headerProxyConfiguration) {
            this.headerProxyConfiguration$value = headerProxyConfiguration;
            this.headerProxyConfiguration$set = true;
            return this;
        }

        public PageRequestConfigurableEnricherBuilder staticHeaderConfiguration(StaticHeaderConfiguration staticHeaderConfiguration) {
            this.staticHeaderConfiguration$value = staticHeaderConfiguration;
            this.staticHeaderConfiguration$set = true;
            return this;
        }

        public PageRequestConfigurableEnricher build() {
            HeaderProxyConfiguration headerProxyConfiguration$value = this.headerProxyConfiguration$value;
            if (!this.headerProxyConfiguration$set) {
                headerProxyConfiguration$value = PageRequestConfigurableEnricher.$default$headerProxyConfiguration();
            }
            StaticHeaderConfiguration staticHeaderConfiguration$value = this.staticHeaderConfiguration$value;
            if (!this.staticHeaderConfiguration$set) {
                staticHeaderConfiguration$value = PageRequestConfigurableEnricher.$default$staticHeaderConfiguration();
            }
            return new PageRequestConfigurableEnricher(headerProxyConfiguration$value, staticHeaderConfiguration$value);
        }

        public String toString() {
            return "PageRequestConfigurableEnricher.PageRequestConfigurableEnricherBuilder(headerProxyConfiguration$value=" + this.headerProxyConfiguration$value + ", staticHeaderConfiguration$value=" + this.staticHeaderConfiguration$value + ")";
        }
    }
}

