/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.proxy.rule;

import io.wttech.markuply.engine.MarkuplyException;
import io.wttech.markuply.engine.pipeline.http.proxy.rule.AllowHeaderRule;
import io.wttech.markuply.engine.pipeline.http.proxy.rule.HeaderMatchingRule;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class HeaderMatchingRuleFactory {
    public HeaderMatchingRule create(String pattern) {
        return this.allow(pattern);
    }

    public HeaderMatchingRule allow(String pattern) {
        try {
            Pattern compiledPattern = Pattern.compile(pattern);
            return AllowHeaderRule.of(compiledPattern);
        }
        catch (PatternSyntaxException e) {
            throw new MarkuplyException("Header name pattern is not a valid regular expression.");
        }
    }

    private HeaderMatchingRuleFactory() {
    }

    public static HeaderMatchingRuleFactory instance() {
        return new HeaderMatchingRuleFactory();
    }
}

