/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.repository;

import io.wttech.markuply.engine.pipeline.http.proxy.request.HttpPageRequest;
import io.wttech.markuply.engine.pipeline.http.proxy.request.ReactiveRequestEnricher;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageRepository;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageResponse;
import io.wttech.markuply.engine.pipeline.repository.PageRepositoryException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class BaseHttpPageRepository
implements HttpPageRepository {
    private static final Logger log = LoggerFactory.getLogger(BaseHttpPageRepository.class);
    private static final List<ExchangeFilterFunction> LOGGING_FILTERS = Arrays.asList(BaseHttpPageRepository.logRequest(), BaseHttpPageRepository.logResponse());
    @NonNull
    private final WebClient webClient;
    @NonNull
    private final String uriPrefix;

    public static BaseHttpPageRepository of(WebClient webClient, String uriPrefix) {
        WebClient clientWithLogging = webClient.mutate().filters(filters -> filters.addAll(LOGGING_FILTERS)).build();
        return new BaseHttpPageRepository(clientWithLogging, uriPrefix);
    }

    @Override
    public Mono<HttpPageResponse> getPage(String url) {
        return this.sendRequest(url, HttpPageRequest.empty());
    }

    @Override
    public Mono<HttpPageResponse> getPage(String url, ReactiveRequestEnricher requestMutator) {
        return requestMutator.enrich(HttpPageRequest.builder()).flatMap(builder -> this.sendRequest(url, builder.build()));
    }

    private Mono<HttpPageResponse> sendRequest(String url, HttpPageRequest requestDetails) {
        WebClient.RequestHeadersUriSpec requestBuilder = this.webClient.get();
        requestBuilder.headers(httpHeaders -> requestDetails.getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).addAll(arg_0, arg_1)));
        try {
            URI uri = new URI(this.uriPrefix + url);
            return requestBuilder.uri(uri).retrieve().onStatus(status -> true, response -> Mono.empty()).toEntity(String.class).map(this::toMarkuplyResponse);
        }
        catch (URISyntaxException e) {
            return Mono.error((Throwable)new PageRepositoryException("The original HTML resource URL is not valid", e));
        }
    }

    private HttpPageResponse toMarkuplyResponse(ResponseEntity<String> response) {
        HttpPageResponse.Builder responseBuilder = HttpPageResponse.builder(response.getStatusCodeValue());
        response.getHeaders().forEach(responseBuilder::addHeader);
        responseBuilder.body((String)response.getBody());
        return responseBuilder.build();
    }

    private static ExchangeFilterFunction logRequest() {
        return ExchangeFilterFunction.ofRequestProcessor(clientRequest -> {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("Original HTML request\n");
                sb.append("URL: ").append(clientRequest.url().toString()).append("\n");
                clientRequest.headers().forEach((name, values) -> values.forEach(value -> sb.append("Header: ").append((String)name).append(":").append(String.join((CharSequence)",", values)).append("\n")));
                log.debug(sb.toString());
            }
            return Mono.just((Object)clientRequest);
        });
    }

    private static ExchangeFilterFunction logResponse() {
        return ExchangeFilterFunction.ofResponseProcessor(clientResponse -> {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("Original HTML response: \n");
                sb.append("Status code: ").append(clientResponse.statusCode().name());
                clientResponse.headers().asHttpHeaders().forEach((name, values) -> values.forEach(value -> sb.append("Header: ").append((String)name).append(":").append(String.join((CharSequence)",", values)).append("\n")));
                log.debug(sb.toString());
            }
            return Mono.just((Object)clientResponse);
        });
    }

    static BaseHttpPageRepositoryBuilder builder() {
        return new BaseHttpPageRepositoryBuilder();
    }

    BaseHttpPageRepository(@NonNull WebClient webClient, @NonNull String uriPrefix) {
        if (webClient == null) {
            throw new NullPointerException("webClient is marked non-null but is null");
        }
        if (uriPrefix == null) {
            throw new NullPointerException("uriPrefix is marked non-null but is null");
        }
        this.webClient = webClient;
        this.uriPrefix = uriPrefix;
    }

    static class BaseHttpPageRepositoryBuilder {
        private WebClient webClient;
        private String uriPrefix;

        BaseHttpPageRepositoryBuilder() {
        }

        BaseHttpPageRepositoryBuilder webClient(@NonNull WebClient webClient) {
            if (webClient == null) {
                throw new NullPointerException("webClient is marked non-null but is null");
            }
            this.webClient = webClient;
            return this;
        }

        BaseHttpPageRepositoryBuilder uriPrefix(@NonNull String uriPrefix) {
            if (uriPrefix == null) {
                throw new NullPointerException("uriPrefix is marked non-null but is null");
            }
            this.uriPrefix = uriPrefix;
            return this;
        }

        BaseHttpPageRepository build() {
            return new BaseHttpPageRepository(this.webClient, this.uriPrefix);
        }

        public String toString() {
            return "BaseHttpPageRepository.BaseHttpPageRepositoryBuilder(webClient=" + this.webClient + ", uriPrefix=" + this.uriPrefix + ")";
        }
    }
}

