/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.repository;

import io.wttech.markuply.engine.pipeline.http.proxy.request.ReactiveRequestEnricher;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageRepository;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageResponse;
import lombok.NonNull;
import reactor.core.publisher.Mono;

public class EnrichedHttpPageRepository
implements HttpPageRepository {
    @NonNull
    private final HttpPageRepository httpPageRepository;
    @NonNull
    private final ReactiveRequestEnricher enricher;

    @Override
    public Mono<HttpPageResponse> getPage(String url) {
        return this.httpPageRepository.getPage(url, this.enricher::enrich);
    }

    @Override
    public Mono<HttpPageResponse> getPage(String url, ReactiveRequestEnricher requestMutator) {
        ReactiveRequestEnricher combined = builder -> this.enricher.enrich(builder).flatMap(requestMutator::enrich);
        return this.httpPageRepository.getPage(url, combined);
    }

    private EnrichedHttpPageRepository(@NonNull HttpPageRepository httpPageRepository, @NonNull ReactiveRequestEnricher enricher) {
        if (httpPageRepository == null) {
            throw new NullPointerException("httpPageRepository is marked non-null but is null");
        }
        if (enricher == null) {
            throw new NullPointerException("enricher is marked non-null but is null");
        }
        this.httpPageRepository = httpPageRepository;
        this.enricher = enricher;
    }

    public static EnrichedHttpPageRepository instance(@NonNull HttpPageRepository httpPageRepository, @NonNull ReactiveRequestEnricher enricher) {
        return new EnrichedHttpPageRepository(httpPageRepository, enricher);
    }
}

