/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpPageResponse {
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final String body;

    public static Builder builder(int statusCode) {
        return new Builder(statusCode);
    }

    public HttpPageResponse withBody(String content) {
        return new HttpPageResponse(this.statusCode, this.headers, content);
    }

    public HttpPageResponse(int statusCode, Map<String, List<String>> headers, String body) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public static class Builder {
        private final int statusCode;
        private String body;
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

        public Builder addHeader(String name, String value) {
            this.headers.computeIfAbsent(name, key -> new ArrayList()).add(value);
            return this;
        }

        public Builder addHeader(String name, List<String> values) {
            values.forEach(value -> this.addHeader(name, (String)value));
            return this;
        }

        public Builder body(String content) {
            this.body = content;
            return this;
        }

        public HttpPageResponse build() {
            return new HttpPageResponse(this.statusCode, this.headers, this.body);
        }

        public Builder(int statusCode) {
            this.statusCode = statusCode;
        }
    }
}

