/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.repository.configuration;

import io.wttech.markuply.engine.pipeline.http.proxy.request.ReactiveRequestEnricher;
import io.wttech.markuply.engine.pipeline.http.repository.BaseHttpPageRepository;
import io.wttech.markuply.engine.pipeline.http.repository.EnrichedHttpPageRepository;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageRepository;
import java.util.Optional;
import org.springframework.web.reactive.function.client.WebClient;

public class HttpPageRepositoryConfigurator {
    private WebClient webClient;
    private String uriPrefix = "";
    private ReactiveRequestEnricher enricher;

    public static HttpPageRepositoryConfigurator instance() {
        return new HttpPageRepositoryConfigurator();
    }

    public HttpPageRepositoryConfigurator uriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
        return this;
    }

    public HttpPageRepositoryConfigurator webClient(WebClient webClient) {
        this.webClient = webClient;
        return this;
    }

    public HttpPageRepositoryConfigurator enricher(ReactiveRequestEnricher enricher) {
        this.enricher = enricher;
        return this;
    }

    public HttpPageRepository build() {
        WebClient webClient = Optional.ofNullable(this.webClient).orElseGet(() -> WebClient.builder().build());
        BaseHttpPageRepository baseRepository = BaseHttpPageRepository.of(webClient, this.uriPrefix);
        if (this.enricher != null) {
            return EnrichedHttpPageRepository.instance(baseRepository, this.enricher);
        }
        return baseRepository;
    }
}

