/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.pipeline.http.repository.configuration;

import io.wttech.markuply.engine.pipeline.http.proxy.request.ReactiveRequestEnricher;
import io.wttech.markuply.engine.pipeline.http.repository.BaseHttpPageRepository;
import io.wttech.markuply.engine.pipeline.http.repository.EnrichedHttpPageRepository;
import io.wttech.markuply.engine.pipeline.http.repository.HttpPageRepository;
import javax.inject.Provider;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
@Scope(value="prototype")
public class HttpPageRepositorySpringConfigurator {
    private static final WebClient DEFAULT_WEB_CLIENT = WebClient.builder().build();
    private final Provider<WebClient> webClientProvider;
    private final Provider<ReactiveRequestEnricher> enricherProvider;
    private WebClient webClient;
    private ReactiveRequestEnricher enricher;
    private String uriPrefix;

    public HttpPageRepositorySpringConfigurator urlPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
        return this;
    }

    public HttpPageRepositorySpringConfigurator webClient(WebClient webClient) {
        this.webClient = webClient;
        return this;
    }

    public HttpPageRepositorySpringConfigurator enricher(ReactiveRequestEnricher enricher) {
        this.enricher = enricher;
        return this;
    }

    public HttpPageRepository build() {
        WebClient finalWebClient = this.calculateFinalWebClient();
        ReactiveRequestEnricher finalEnricher = this.calculateFinalEnricher();
        BaseHttpPageRepository baseRepository = BaseHttpPageRepository.of(finalWebClient, this.uriPrefix);
        if (finalEnricher != null) {
            return EnrichedHttpPageRepository.instance(baseRepository, finalEnricher);
        }
        return baseRepository;
    }

    private ReactiveRequestEnricher calculateFinalEnricher() {
        return this.calculateFinalValue(this.enricher, this.enricherProvider, null);
    }

    private WebClient calculateFinalWebClient() {
        return this.calculateFinalValue(this.webClient, this.webClientProvider, DEFAULT_WEB_CLIENT);
    }

    private <T> T calculateFinalValue(T direct, Provider<T> provider, T defaultValue) {
        if (direct == null) {
            Object fromProvider = provider.get();
            if (fromProvider == null) {
                return defaultValue;
            }
            return (T)fromProvider;
        }
        return direct;
    }

    public HttpPageRepositorySpringConfigurator(Provider<WebClient> webClientProvider, Provider<ReactiveRequestEnricher> enricherProvider) {
        this.webClientProvider = webClientProvider;
        this.enricherProvider = enricherProvider;
    }
}

