/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.renderer;

import io.wttech.markuply.engine.component.MarkuplyComponentContext;
import io.wttech.markuply.engine.pipeline.context.PageContext;
import io.wttech.markuply.engine.renderer.error.ComponentErrorHandler;
import io.wttech.markuply.engine.renderer.missing.MissingComponentHandler;
import io.wttech.markuply.engine.renderer.registry.ComponentRegistry;
import io.wttech.markuply.engine.template.graph.NamedRenderFunctions;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ComponentRenderer {
    private static final Logger log = LoggerFactory.getLogger(ComponentRenderer.class);
    @NonNull
    private final ComponentRegistry componentRegistry;
    @NonNull
    private final MissingComponentHandler missingComponentHandler;
    @NonNull
    private final ComponentErrorHandler errorHandler;

    public Mono<String> render(String componentId, String props, PageContext context, NamedRenderFunctions childrenRenderer) {
        return this.componentRegistry.find(componentId).map(component -> {
            log.debug("Rendering component: {}. Props: {}. Context: {}.", new Object[]{componentId, props, context});
            return component.render(MarkuplyComponentContext.of(props, context, childrenRenderer));
        }).orElseGet(() -> this.missingComponentHandler.missingComponent(componentId, props, context)).onErrorResume(e -> this.errorHandler.handleError((Throwable)e, componentId, props, context));
    }

    private ComponentRenderer(@NonNull ComponentRegistry componentRegistry, @NonNull MissingComponentHandler missingComponentHandler, @NonNull ComponentErrorHandler errorHandler) {
        if (componentRegistry == null) {
            throw new NullPointerException("componentRegistry is marked non-null but is null");
        }
        if (missingComponentHandler == null) {
            throw new NullPointerException("missingComponentHandler is marked non-null but is null");
        }
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        this.componentRegistry = componentRegistry;
        this.missingComponentHandler = missingComponentHandler;
        this.errorHandler = errorHandler;
    }

    public static ComponentRenderer of(@NonNull ComponentRegistry componentRegistry, @NonNull MissingComponentHandler missingComponentHandler, @NonNull ComponentErrorHandler errorHandler) {
        return new ComponentRenderer(componentRegistry, missingComponentHandler, errorHandler);
    }
}

