/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.renderer;

import io.wttech.markuply.engine.renderer.ComponentRenderer;
import io.wttech.markuply.engine.renderer.RenderFunctionFactory;
import io.wttech.markuply.engine.template.graph.RenderFunction;
import io.wttech.markuply.engine.template.graph.RenderingVisitor;
import io.wttech.markuply.engine.template.graph.node.FragmentGraph;
import io.wttech.markuply.engine.template.parser.TemplateParser;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRenderFunctionFactory
implements RenderFunctionFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultRenderFunctionFactory.class);
    @NonNull
    private final TemplateParser templateParser;
    @NonNull
    private final ComponentRenderer componentRenderer;

    @Override
    public RenderFunction create(String html) {
        FragmentGraph fragmentGraph = this.templateParser.parse(html);
        RenderingVisitor visitor = RenderingVisitor.of(this.componentRenderer);
        return fragmentGraph.accept(visitor);
    }

    private DefaultRenderFunctionFactory(@NonNull TemplateParser templateParser, @NonNull ComponentRenderer componentRenderer) {
        if (templateParser == null) {
            throw new NullPointerException("templateParser is marked non-null but is null");
        }
        if (componentRenderer == null) {
            throw new NullPointerException("componentRenderer is marked non-null but is null");
        }
        this.templateParser = templateParser;
        this.componentRenderer = componentRenderer;
    }

    public static DefaultRenderFunctionFactory instance(@NonNull TemplateParser templateParser, @NonNull ComponentRenderer componentRenderer) {
        return new DefaultRenderFunctionFactory(templateParser, componentRenderer);
    }
}

