/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.renderer.cache;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.wttech.markuply.engine.renderer.RenderFunctionFactory;
import io.wttech.markuply.engine.template.graph.RenderFunction;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

public class RenderFunctionCache {
    private final AsyncLoadingCache<RenderFunctionKey, RenderFunction> cache;

    public static RenderFunctionCache instance(RenderFunctionFactory factory, Caffeine<Object, Object> cacheConfiguration) {
        return new RenderFunctionCache((AsyncLoadingCache<RenderFunctionKey, RenderFunction>)cacheConfiguration.buildAsync(key -> factory.create(((RenderFunctionKey)key).input)));
    }

    public Mono<RenderFunction> get(Object key, String input) {
        RenderFunctionKey realKey = RenderFunctionKey.instance(key, input);
        CompletableFuture future = this.cache.get((Object)realKey);
        return Mono.fromFuture((CompletableFuture)future);
    }

    public RenderFunctionCache(AsyncLoadingCache<RenderFunctionKey, RenderFunction> cache) {
        this.cache = cache;
    }

    public static class RenderFunctionKey {
        private final Object key;
        private final String input;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenderFunctionKey that = (RenderFunctionKey)o;
            return this.key.equals(that.key) && this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        private RenderFunctionKey(Object key, String input) {
            this.key = key;
            this.input = input;
        }

        public static RenderFunctionKey instance(Object key, String input) {
            return new RenderFunctionKey(key, input);
        }

        public Object getKey() {
            return this.key;
        }

        public String getInput() {
            return this.input;
        }
    }
}

