/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.renderer.cache;

import io.wttech.markuply.engine.configuration.OptionalProperties;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

@ConfigurationProperties(value="markuply.cache.render")
@ConstructorBinding
public class RenderFunctionCacheProperties
implements OptionalProperties {
    public static final String PREFIX = "markuply.cache.render";
    public static final Duration DEFAULT_EXPIRY = Duration.ofSeconds(1L);
    public static final long DEFAULT_MAX_SIZE = 1000L;
    private final boolean enabled;
    private final Duration expireAfterAccess;
    private final Long maxSize;

    @Override
    public boolean isPresent() {
        return this.enabled;
    }

    public Duration getExpireAfterAccess() {
        return this.expireAfterAccess != null ? this.expireAfterAccess : DEFAULT_EXPIRY;
    }

    public Long getMaxSize() {
        return this.maxSize != null ? this.maxSize : 1000L;
    }

    public RenderFunctionCacheProperties(boolean enabled, Duration expireAfterAccess, Long maxSize) {
        this.enabled = enabled;
        this.expireAfterAccess = expireAfterAccess;
        this.maxSize = maxSize;
    }
}

