/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.renderer.error;

import io.wttech.markuply.engine.pipeline.context.PageContext;
import io.wttech.markuply.engine.renderer.error.ComponentErrorHandler;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class LogOrPropagateErrorHandler
implements ComponentErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(LogOrPropagateErrorHandler.class);
    @NonNull
    private final List<Class<? extends Throwable>> propagate;

    @Override
    public Mono<String> handleError(Throwable throwable, String componentId, String props, PageContext context) {
        boolean typeToPropagate = this.propagate.stream().anyMatch(type -> type.isAssignableFrom(throwable.getClass()));
        if (typeToPropagate) {
            return Mono.error((Throwable)throwable);
        }
        log.error("Error occurred during component rendering. Component: {}, props: {}", new Object[]{componentId, props, throwable});
        return Mono.just((Object)"");
    }

    LogOrPropagateErrorHandler(@NonNull List<Class<? extends Throwable>> propagate) {
        if (propagate == null) {
            throw new NullPointerException("propagate is marked non-null but is null");
        }
        this.propagate = propagate;
    }
}

