/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.renderer.registry;

import io.wttech.markuply.engine.component.ComponentDefinitionException;
import io.wttech.markuply.engine.component.MarkuplyComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRegistry {
    private static final Logger log = LoggerFactory.getLogger(ComponentRegistry.class);
    private final Map<String, MarkuplyComponent> components;

    public static ComponentRegistry instance() {
        return new ComponentRegistry(new HashMap<String, MarkuplyComponent>());
    }

    public MarkuplyComponent get(String componentId) {
        return this.find(componentId).orElseThrow(() -> new IllegalArgumentException("Component named " + componentId + " is not registered"));
    }

    public Optional<MarkuplyComponent> find(String componentId) {
        return Optional.ofNullable(this.components.get(componentId));
    }

    public void register(String name, MarkuplyComponent component) {
        if (this.components.containsKey(name)) {
            throw new ComponentDefinitionException("Component of name " + name + " already exists.");
        }
        this.components.put(name, component);
        log.info("Registered component named {} of class {}", (Object)name, (Object)component.getClass().getSimpleName());
    }

    public ComponentRegistry(Map<String, MarkuplyComponent> components) {
        this.components = components;
    }
}

