/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.renderer.spring;

import io.wttech.markuply.engine.component.Markuply;
import io.wttech.markuply.engine.component.method.LambdaComponentFactory;
import io.wttech.markuply.engine.component.method.MethodComponent;
import io.wttech.markuply.engine.renderer.registry.ComponentRegistry;
import java.lang.reflect.Method;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class MarkuplyBeanPostProcessor
implements BeanPostProcessor {
    private final LambdaComponentFactory methodComponentFactory;
    private final ComponentRegistry registry;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Method[] methods;
        Class<?> beanClass = bean.getClass();
        for (Method method : methods = beanClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Markuply.class)) continue;
            Markuply markuplyAnnotation = method.getAnnotation(Markuply.class);
            String componentName = markuplyAnnotation.value().isEmpty() ? method.getName() : markuplyAnnotation.value();
            MethodComponent component = this.methodComponentFactory.build(bean, method);
            this.registry.register(componentName, component);
        }
        return bean;
    }

    private MarkuplyBeanPostProcessor(LambdaComponentFactory methodComponentFactory, ComponentRegistry registry) {
        this.methodComponentFactory = methodComponentFactory;
        this.registry = registry;
    }

    public static MarkuplyBeanPostProcessor of(LambdaComponentFactory methodComponentFactory, ComponentRegistry registry) {
        return new MarkuplyBeanPostProcessor(methodComponentFactory, registry);
    }
}

