/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.request.cache;

import io.wttech.markuply.engine.request.cache.CacheKey;
import io.wttech.markuply.engine.request.cache.RequestScopedCache;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Aspect
public class RequestCacheAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestCacheAspect.class);

    @Pointcut(value="@within(io.wttech.markuply.engine.request.cache.RequestCache)")
    public void withinAnnotatedClass() {
    }

    @Pointcut(value="@annotation(io.wttech.markuply.engine.request.cache.RequestCache)")
    public void annotatedMethod() {
    }

    @Pointcut(value="execution(public reactor.core.publisher.Mono+ *(..))")
    public void monoReturnType() {
    }

    @Pointcut(value="execution(public reactor.core.publisher.Flux+ *(..))")
    public void fluxReturnType() {
    }

    @Around(value="(withinAnnotatedClass() || annotatedMethod()) && monoReturnType()")
    public Mono<?> cacheMono(ProceedingJoinPoint pjp) {
        return Mono.deferContextual(Mono::just).flatMap(context -> {
            CacheKey cacheKey;
            RequestScopedCache requestScopedCache = (RequestScopedCache)context.get(RequestScopedCache.class);
            Object result = requestScopedCache.findCachedResult(cacheKey = this.calculateKey(pjp));
            if (result == RequestScopedCache.NONE) {
                log.debug("Cache miss for method {}.{}()", (Object)pjp.getSignature().getDeclaringTypeName(), (Object)pjp.getSignature().getName());
                try {
                    Mono cachedMethodResult = (Mono)pjp.proceed();
                    result = requestScopedCache.save(cacheKey, cachedMethodResult.cache());
                }
                catch (Throwable throwable) {
                    return Mono.error((Throwable)throwable);
                }
            } else {
                log.debug("Cache hit for method {}.{}()", (Object)pjp.getSignature().getDeclaringTypeName(), (Object)pjp.getSignature().getName());
            }
            return result == RequestScopedCache.NULL ? Mono.empty() : (Mono)result;
        });
    }

    @Around(value="(withinAnnotatedClass() || annotatedMethod()) && fluxReturnType()")
    public Flux<?> cacheFlux(ProceedingJoinPoint pjp) {
        return Mono.deferContextual(Mono::just).flatMapMany(context -> {
            CacheKey cacheKey;
            RequestScopedCache requestScopedCache = (RequestScopedCache)context.get(RequestScopedCache.class);
            Object result = requestScopedCache.findCachedResult(cacheKey = this.calculateKey(pjp));
            if (result == RequestScopedCache.NONE) {
                log.debug("Cache miss for method {}.{}()", (Object)pjp.getSignature().getDeclaringTypeName(), (Object)pjp.getSignature().getName());
                try {
                    Flux cachedMethodResult = (Flux)pjp.proceed();
                    result = requestScopedCache.save(cacheKey, cachedMethodResult.cache());
                }
                catch (Throwable throwable) {
                    return Flux.error((Throwable)throwable);
                }
            } else {
                log.debug("Cache hit for method {}.{}()", (Object)pjp.getSignature().getDeclaringTypeName(), (Object)pjp.getSignature().getName());
            }
            return result == RequestScopedCache.NULL ? Flux.empty() : (Flux)result;
        });
    }

    private CacheKey calculateKey(ProceedingJoinPoint pjp) {
        return CacheKey.of(pjp.getSignature().getDeclaringType(), pjp.getSignature().getName(), pjp.getArgs());
    }
}

