/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.template.graph;

import io.wttech.markuply.engine.MarkuplyException;
import io.wttech.markuply.engine.template.graph.RenderFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class NamedRenderFunctions {
    public static final NamedRenderFunctions NO_OP = NamedRenderFunctions.builder().addSection(RenderFunction.NO_OP).build();
    private final Map<String, RenderFunction> sections;

    public Optional<RenderFunction> findSection(String name) {
        return Optional.ofNullable(this.sections.get(name));
    }

    public Optional<RenderFunction> findDefaultSection() {
        return Optional.ofNullable(this.sections.get(""));
    }

    public static Builder builder() {
        return new Builder();
    }

    public NamedRenderFunctions(Map<String, RenderFunction> sections) {
        this.sections = sections;
    }

    public static class Builder {
        private final Map<String, RenderFunction> sections = new HashMap<String, RenderFunction>();

        public Builder addSection(RenderFunction renderFunction) {
            return this.addSection("", renderFunction);
        }

        public Builder addSection(String name, RenderFunction renderFunction) {
            if (this.sections.containsKey(name)) {
                throw new MarkuplyException("Cannot add another section with the same name");
            }
            this.sections.put(name, renderFunction);
            return this;
        }

        public NamedRenderFunctions build() {
            return new NamedRenderFunctions(this.sections);
        }
    }
}

