/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.template.graph;

import io.wttech.markuply.engine.renderer.ComponentRenderer;
import io.wttech.markuply.engine.template.graph.FragmentGraphVisitor;
import io.wttech.markuply.engine.template.graph.NamedRenderFunctions;
import io.wttech.markuply.engine.template.graph.RenderFunction;
import io.wttech.markuply.engine.template.graph.node.ComponentFragment;
import io.wttech.markuply.engine.template.graph.node.ComponentSectionFragment;
import io.wttech.markuply.engine.template.graph.node.FragmentGraph;
import io.wttech.markuply.engine.template.graph.node.StaticFragment;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RenderingVisitor
implements FragmentGraphVisitor<RenderFunction> {
    private final ComponentRenderer componentRenderer;

    @Override
    public RenderFunction visit(ComponentFragment componentFragment) {
        NamedRenderFunctions sectionFunctions = this.handleSections(componentFragment.getSections());
        return context -> this.componentRenderer.render(componentFragment.getComponentId(), componentFragment.getProps(), context, sectionFunctions);
    }

    private NamedRenderFunctions handleSections(List<ComponentSectionFragment> sections) {
        NamedRenderFunctions.Builder builder = NamedRenderFunctions.builder();
        sections.forEach(section -> builder.addSection(section.getName(), this.handleChildren(section.getChildren())));
        return builder.build();
    }

    private RenderFunction handleChildren(List<FragmentGraph> children) {
        List innerFunctions = children.stream().map(fragment -> fragment.accept(this)).collect(Collectors.toList());
        return context -> Flux.fromIterable((Iterable)innerFunctions).flatMapSequential(childRenderer -> childRenderer.render(context)).collect(Collectors.joining());
    }

    @Override
    public RenderFunction visit(StaticFragment staticFragment) {
        return context -> Mono.just((Object)staticFragment.getContent());
    }

    @Override
    public RenderFunction visit(List<FragmentGraph> children) {
        return this.handleChildren(children);
    }

    private RenderingVisitor(ComponentRenderer componentRenderer) {
        this.componentRenderer = componentRenderer;
    }

    public static RenderingVisitor of(ComponentRenderer componentRenderer) {
        return new RenderingVisitor(componentRenderer);
    }
}

