/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.template.parser.atto;

import io.wttech.markuply.engine.template.graph.node.ComponentFragment;
import io.wttech.markuply.engine.template.graph.node.ComponentSectionFragment;
import io.wttech.markuply.engine.template.parser.atto.ComponentHandler;
import io.wttech.markuply.engine.template.parser.atto.DepthCounter;
import io.wttech.markuply.engine.template.parser.atto.DepthlessContentHandler;
import io.wttech.markuply.engine.template.parser.atto.FragmentHandler;
import io.wttech.markuply.engine.template.parser.atto.MarkuplyAttributesWrapper;
import io.wttech.markuply.engine.template.parser.atto.StackContext;
import io.wttech.markuply.engine.template.parser.atto.StaticHandler;
import org.attoparser.AbstractMarkupHandler;
import org.attoparser.IMarkupHandler;
import org.attoparser.ParseException;

public class ComponentSectionHandler
extends AbstractMarkupHandler
implements FragmentHandler {
    private final String name;
    private final DepthCounter counter = DepthCounter.instance(1);
    private final StackContext stackContext;
    private final DepthlessContentHandler depthlessContentHandler = DepthlessContentHandler.instance();
    private StaticHandler bufferHandler;
    private IMarkupHandler targetHandler = this.depthlessContentHandler;
    private final MarkuplyAttributesWrapper attributes = MarkuplyAttributesWrapper.instance();

    public static ComponentSectionHandler instance(String name, StackContext stack) {
        return new ComponentSectionHandler(name, stack);
    }

    public ComponentSectionFragment getResult() {
        return ComponentSectionFragment.instance(this.name, this.depthlessContentHandler.getResult());
    }

    private void startUndeterminedMode() {
        this.bufferHandler = StaticHandler.instance();
        this.targetHandler = this.bufferHandler;
    }

    private void startStaticMode() {
        this.targetHandler = this.depthlessContentHandler;
    }

    private void undeterminedToStaticMode() {
        this.depthlessContentHandler.append(this.bufferHandler);
        this.targetHandler = this.depthlessContentHandler;
    }

    private void startComponentMode() {
        this.endStaticMode();
        String componentId = this.attributes.getComponentId();
        String props = this.attributes.getProps();
        this.stackContext.push(ComponentHandler.instance(componentId, props, this.stackContext));
        this.startStaticMode();
    }

    private void processSimpleComponent() {
        this.endStaticMode();
        String componentId = this.attributes.getComponentId();
        String props = this.attributes.getProps();
        this.depthlessContentHandler.append(ComponentFragment.simple(props, componentId));
        this.startStaticMode();
    }

    private void endStaticMode() {
        this.depthlessContentHandler.endStatic();
    }

    @Override
    public void handleInnerResult(ComponentHandler handler) {
        this.depthlessContentHandler.append(handler.getResult());
    }

    @Override
    public void handleInnerResult(ComponentSectionHandler handler) {
        throw new IllegalStateException("Section must be a direct child of a component");
    }

    @Override
    public void reportEndToParent(FragmentHandler handler) {
        handler.handleInnerResult(this);
    }

    public void handleDocumentStart(long startTimeNanos, int line, int col) throws ParseException {
        this.targetHandler.handleDocumentStart(startTimeNanos, line, col);
    }

    public void handleDocumentEnd(long endTimeNanos, long totalTimeNanos, int line, int col) throws ParseException {
        this.targetHandler.handleDocumentEnd(endTimeNanos, totalTimeNanos, line, col);
    }

    public void handleXmlDeclaration(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int versionOffset, int versionLen, int versionLine, int versionCol, int encodingOffset, int encodingLen, int encodingLine, int encodingCol, int standaloneOffset, int standaloneLen, int standaloneLine, int standaloneCol, int outerOffset, int outerLen, int line, int col) throws ParseException {
        this.targetHandler.handleXmlDeclaration(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, versionOffset, versionLen, versionLine, versionCol, encodingOffset, encodingLen, encodingLine, encodingCol, standaloneOffset, standaloneLen, standaloneLine, standaloneCol, outerOffset, outerLen, line, col);
    }

    public void handleDocType(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int elementNameOffset, int elementNameLen, int elementNameLine, int elementNameCol, int typeOffset, int typeLen, int typeLine, int typeCol, int publicIdOffset, int publicIdLen, int publicIdLine, int publicIdCol, int systemIdOffset, int systemIdLen, int systemIdLine, int systemIdCol, int internalSubsetOffset, int internalSubsetLen, int internalSubsetLine, int internalSubsetCol, int outerOffset, int outerLen, int outerLine, int outerCol) throws ParseException {
        this.targetHandler.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, publicIdOffset, publicIdLen, publicIdLine, publicIdCol, systemIdOffset, systemIdLen, systemIdLine, systemIdCol, internalSubsetOffset, internalSubsetLen, internalSubsetLine, internalSubsetCol, outerOffset, outerLen, outerLine, outerCol);
    }

    public void handleCDATASection(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws ParseException {
        this.targetHandler.handleCDATASection(buffer, contentOffset, contentLen, outerOffset, outerLen, line, col);
    }

    public void handleComment(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws ParseException {
        this.targetHandler.handleComment(buffer, contentOffset, contentLen, outerOffset, outerLen, line, col);
    }

    public void handleText(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        this.targetHandler.handleText(buffer, offset, len, line, col);
    }

    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws ParseException {
        this.startUndeterminedMode();
        this.targetHandler.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
    }

    public void handleStandaloneElementEnd(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws ParseException {
        this.targetHandler.handleStandaloneElementEnd(buffer, nameOffset, nameLen, minimized, line, col);
        if (this.attributes.isComponentAttributePresent()) {
            this.processSimpleComponent();
        } else {
            this.undeterminedToStaticMode();
        }
        this.attributes.clear();
    }

    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.startUndeterminedMode();
        this.counter.increment();
        this.targetHandler.handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
    }

    public void handleOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.targetHandler.handleOpenElementEnd(buffer, nameOffset, nameLen, line, col);
        if (this.attributes.isComponentAttributePresent()) {
            this.startComponentMode();
            this.counter.decrement();
        } else {
            this.undeterminedToStaticMode();
        }
        this.attributes.clear();
    }

    public void handleAutoOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.targetHandler.handleAutoOpenElementStart(buffer, nameOffset, nameLen, line, col);
    }

    public void handleAutoOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.targetHandler.handleAutoOpenElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    public void handleCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.counter.decrement();
        if (!this.counter.isZero()) {
            this.targetHandler.handleCloseElementStart(buffer, nameOffset, nameLen, line, col);
        }
    }

    public void handleCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        if (!this.counter.isZero()) {
            this.targetHandler.handleCloseElementEnd(buffer, nameOffset, nameLen, line, col);
        } else {
            this.endStaticMode();
            this.stackContext.pop();
        }
    }

    public void handleAutoCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.targetHandler.handleAutoCloseElementStart(buffer, nameOffset, nameLen, line, col);
    }

    public void handleAutoCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.targetHandler.handleAutoCloseElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    public void handleUnmatchedCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.counter.decrement();
        if (!this.counter.isZero()) {
            this.targetHandler.handleUnmatchedCloseElementStart(buffer, nameOffset, nameLen, line, col);
        }
    }

    public void handleUnmatchedCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        if (!this.counter.isZero()) {
            this.targetHandler.handleUnmatchedCloseElementEnd(buffer, nameOffset, nameLen, line, col);
        } else {
            this.endStaticMode();
            this.stackContext.pop();
        }
    }

    public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws ParseException {
        this.targetHandler.handleAttribute(buffer, nameOffset, nameLen, nameLine, nameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, valueLine, valueCol);
        this.attributes.extractValidAttribute(buffer, nameOffset, nameLen, valueContentOffset, valueContentLen);
    }

    public void handleInnerWhiteSpace(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        this.targetHandler.handleInnerWhiteSpace(buffer, offset, len, line, col);
    }

    public void handleProcessingInstruction(char[] buffer, int targetOffset, int targetLen, int targetLine, int targetCol, int contentOffset, int contentLen, int contentLine, int contentCol, int outerOffset, int outerLen, int line, int col) throws ParseException {
        this.targetHandler.handleProcessingInstruction(buffer, targetOffset, targetLen, targetLine, targetCol, contentOffset, contentLen, contentLine, contentCol, outerOffset, outerLen, line, col);
    }

    ComponentSectionHandler(String name, StackContext stackContext) {
        this.name = name;
        this.stackContext = stackContext;
    }
}

