/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.template.parser.atto;

import io.wttech.markuply.engine.template.parser.atto.MarkuplyAttributes;

public class MarkuplyAttributesWrapper {
    private MarkuplyAttributes attributes;

    public boolean isComponentAttributePresent() {
        return this.attributes != null && this.attributes.isComponentAttributePresent();
    }

    public boolean isSectionAttributePresent() {
        return this.attributes != null && this.attributes.isSectionAttributePresent();
    }

    public String getComponentId() {
        return this.attributes.getComponentId();
    }

    public String getProps() {
        return this.attributes != null && this.attributes.getProps() != null ? this.attributes.getProps() : "";
    }

    public String getSectionName() {
        return this.attributes.getSectionName();
    }

    public void clear() {
        this.attributes = null;
    }

    public void extractValidAttribute(char[] buffer, int offset, int length, int valueOffset, int valueLength) {
        String attributeValue;
        if (this.checkMatch(buffer, offset, length, "data-markuply-component")) {
            attributeValue = new String(buffer, valueOffset, valueLength);
            if (this.attributes == null) {
                this.attributes = MarkuplyAttributes.instance();
            }
            this.attributes.setComponentId(attributeValue);
        }
        if (this.checkMatch(buffer, offset, length, "data-props")) {
            attributeValue = new String(buffer, valueOffset, valueLength);
            if (this.attributes == null) {
                this.attributes = MarkuplyAttributes.instance();
            }
            this.attributes.setProps(attributeValue);
        }
        if (this.checkMatch(buffer, offset, length, "data-markuply-section")) {
            attributeValue = new String(buffer, valueOffset, valueLength);
            if (this.attributes == null) {
                this.attributes = MarkuplyAttributes.instance();
            }
            this.attributes.setSectionName(attributeValue);
        }
    }

    private boolean checkMatch(char[] buffer, int offset, int length, String targetString) {
        if (length == targetString.length()) {
            for (int i = 0; i < length; ++i) {
                if (buffer[offset + i] == targetString.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private MarkuplyAttributesWrapper() {
    }

    public static MarkuplyAttributesWrapper instance() {
        return new MarkuplyAttributesWrapper();
    }
}

