/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.utils;

import io.wttech.markuply.engine.utils.InputStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ClasspathFileLoader {
    public Mono<String> load(String path) {
        return this.load(path, ClasspathFileLoader.class);
    }

    public Mono<String> load(String path, Class<?> clazz) {
        return Mono.fromCallable(() -> this.loadContent(path, clazz)).subscribeOn(Schedulers.boundedElastic());
    }

    public String loadBlocking(String path) {
        return this.loadBlocking(path, ClasspathFileLoader.class);
    }

    public String loadBlocking(String path, Class<?> clazz) {
        return this.loadContent(path, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadContent(String path, Class<?> clazz) {
        try (InputStream inputStream = clazz.getResourceAsStream(path);){
            String string = InputStreamUtils.readAll(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ClasspathFileLoader() {
    }

    public static ClasspathFileLoader instance() {
        return new ClasspathFileLoader();
    }
}

