/*
 * Decompiled with CFR 0.152.
 */
package io.wttech.markuply.engine.webclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

public class WebClientBuilder {
    private Integer connectTimeoutMillis;
    private Long readTimeoutMillis;
    private Integer maxSize;
    private boolean gzipEnabled = false;

    public static WebClientBuilder instance() {
        return new WebClientBuilder();
    }

    public WebClientBuilder connectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public WebClientBuilder readTimeoutMillis(long readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public WebClientBuilder maxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public WebClientBuilder enableGzip() {
        this.gzipEnabled = true;
        return this;
    }

    public WebClient build() {
        WebClient.Builder builder = WebClient.builder();
        this.configureTimeouts(builder);
        this.configureMaxSize(builder);
        return builder.build();
    }

    private void configureTimeouts(WebClient.Builder builder) {
        HttpClient httpClient = HttpClient.create();
        httpClient = httpClient.compress(this.gzipEnabled);
        httpClient = this.configureTcpClient(httpClient);
        ReactorClientHttpConnector connector = new ReactorClientHttpConnector(httpClient);
        builder.clientConnector((ClientHttpConnector)connector);
    }

    private void configureMaxSize(WebClient.Builder builder) {
        if (this.maxSize != null) {
            builder.exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(this.maxSize.intValue())).build());
        }
    }

    private HttpClient configureTcpClient(HttpClient tcpClient) {
        HttpClient result = tcpClient;
        if (this.connectTimeoutMillis != null) {
            result = (HttpClient)result.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeoutMillis);
        }
        if (this.readTimeoutMillis != null) {
            result = (HttpClient)result.doOnConnected(conn -> conn.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS)));
        }
        return result;
    }
}

