/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.BasicType;
import io.xlate.edi.internal.schema.VersionedProperty;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.schema.EDIType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;

class ElementType
extends BasicType
implements EDISimpleType {
    private static final String TOSTRING_FORMAT = "id: %s, type: %s, base: %s, code: %s, minLength: %d, maxLength: %d, values: %s";
    final EDISimpleType.Base base;
    final int scale;
    final String code;
    final int number;
    final long minLength;
    final long maxLength;
    final Map<String, String> values;
    final List<Version> versions;

    ElementType(String id, EDISimpleType.Base base, int scale, String code, int number, long minLength, long maxLength, Map<String, String> values, List<Version> versions, String title, String description) {
        super(id, EDIType.Type.ELEMENT, title, description);
        this.base = base;
        this.scale = scale;
        this.code = code;
        this.number = number;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.values = Collections.unmodifiableMap(new LinkedHashMap<String, String>(values));
        this.versions = Collections.unmodifiableList(new ArrayList<Version>(versions));
    }

    <T> T getVersionAttribute(String version, BiFunction<Version, ElementType, T> versionedSupplier, Supplier<T> defaultSupplier) {
        for (Version ver : this.versions) {
            if (!ver.appliesTo(version)) continue;
            return versionedSupplier.apply(ver, this);
        }
        return defaultSupplier.get();
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, new Object[]{this.getId(), this.getType(), this.base, this.code, this.minLength, this.maxLength, this.values});
    }

    @Override
    public EDISimpleType.Base getBase() {
        return this.base;
    }

    @Override
    public Integer getScale() {
        if (this.scale > -1) {
            return this.scale;
        }
        return EDISimpleType.super.getScale();
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public boolean hasVersions() {
        return !this.versions.isEmpty();
    }

    @Override
    @Deprecated
    public int getNumber() {
        return this.number;
    }

    @Override
    public long getMinLength() {
        return this.minLength;
    }

    @Override
    public long getMinLength(String version) {
        return this.getVersionAttribute(version, Version::getMinLength, this::getMinLength);
    }

    @Override
    public long getMaxLength() {
        return this.maxLength;
    }

    @Override
    public long getMaxLength(String version) {
        return this.getVersionAttribute(version, Version::getMaxLength, this::getMaxLength);
    }

    @Override
    public Map<String, String> getValues() {
        return this.values;
    }

    @Override
    public Map<String, String> getValues(String version) {
        return this.getVersionAttribute(version, Version::getValues, this::getValues);
    }

    static class Version
    extends VersionedProperty {
        final Optional<Long> minLength;
        final Optional<Long> maxLength;
        final Optional<Map<String, String>> values;

        Version(String minVersion, String maxVersion, Long minLength, Long maxLength, Map<String, String> values) {
            super(minVersion, maxVersion);
            this.minLength = Optional.ofNullable(minLength);
            this.maxLength = Optional.ofNullable(maxLength);
            this.values = Optional.ofNullable(values);
        }

        public long getMinLength(ElementType defaultElement) {
            return this.minLength.orElseGet(defaultElement::getMinLength);
        }

        public long getMaxLength(ElementType defaultElement) {
            return this.maxLength.orElseGet(defaultElement::getMaxLength);
        }

        public Map<String, String> getValues(ElementType defaultElement) {
            return this.values.orElseGet(defaultElement::getValues);
        }
    }
}

