/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.Reference;
import io.xlate.edi.internal.schema.SchemaReader;
import io.xlate.edi.internal.schema.SchemaReaderBase;
import io.xlate.edi.internal.schema.StaEDISchema;
import io.xlate.edi.internal.schema.StaEDISchemaFactory;
import io.xlate.edi.internal.schema.implementation.BaseComplexImpl;
import io.xlate.edi.internal.schema.implementation.BaseImpl;
import io.xlate.edi.internal.schema.implementation.CompositeImpl;
import io.xlate.edi.internal.schema.implementation.DiscriminatorImpl;
import io.xlate.edi.internal.schema.implementation.ElementImpl;
import io.xlate.edi.internal.schema.implementation.LoopImpl;
import io.xlate.edi.internal.schema.implementation.Positioned;
import io.xlate.edi.internal.schema.implementation.SegmentImpl;
import io.xlate.edi.internal.schema.implementation.TransactionImpl;
import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDIElementPosition;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.implementation.Discriminator;
import io.xlate.edi.schema.implementation.EDITypeImplementation;
import io.xlate.edi.schema.implementation.LoopImplementation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;

class SchemaReaderV3
extends SchemaReaderBase
implements SchemaReader {
    private static final Logger LOGGER = Logger.getLogger(SchemaReaderV3.class.getName());
    private static final String ATTR_POSITION = "position";
    private static final String ATTR_DISCRIMINATOR = "discriminator";
    final Deque<EDITypeImplementation> implementedTypes = new LinkedList<EDITypeImplementation>();
    final ValueSet valueSet = new ValueSet();

    protected SchemaReaderV3(String xmlns, XMLStreamReader reader, Map<String, Object> properties) {
        super(xmlns, reader, properties);
    }

    public SchemaReaderV3(XMLStreamReader reader, Map<String, Object> properties) {
        this("http://xlate.io/EDISchema/v3", reader, properties);
    }

    @Override
    protected String readReferencedId(XMLStreamReader reader) {
        String id = reader.getAttributeValue(null, "type");
        if (id == null && (id = reader.getAttributeValue(null, "ref")) != null) {
            Location parseLocation = reader.getLocation();
            LOGGER.warning("Attribute 'ref' is deprecated at line " + parseLocation.getLineNumber() + ", column " + parseLocation.getColumnNumber());
        }
        return id;
    }

    @Override
    protected void readInclude(XMLStreamReader reader, Map<String, EDIType> types) throws EDISchemaException {
        throw StaEDISchemaFactory.unexpectedElement(reader.getName(), reader);
    }

    @Override
    protected void readImplementation(XMLStreamReader reader, Map<String, EDIType> types) {
        QName element = reader.getName();
        if (this.qnImplementation.equals(element)) {
            LoopImplementation impl = this.readImplementation(reader, element, types);
            if (impl != null) {
                types.put("io.xlate.edi.internal.schema.IMPLEMENTATION", impl);
            }
            this.nextTag(reader, "seeking next element after implementation end");
        }
    }

    @Override
    void setReferences(Map<String, EDIType> types) {
        super.setReferences(types);
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.implementedTypes.descendingIterator(), 16), false).filter(type -> type.getType() != EDIType.Type.ELEMENT).map(BaseComplexImpl.class::cast).forEach(type -> this.setReferences((BaseComplexImpl)type, types));
    }

    void setReferences(BaseComplexImpl type, Map<String, EDIType> types) {
        String typeId = type.getTypeId();
        EDIComplexType standard = (EDIComplexType)types.get(typeId);
        if (standard == null) {
            throw StaEDISchemaFactory.schemaException("Type " + typeId + " does not correspond to a standard type");
        }
        List<EDIReference> standardRefs = standard.getReferences();
        List<EDITypeImplementation> implSequence = type.getSequence();
        if (implSequence.isEmpty()) {
            implSequence.addAll(this.getDefaultSequence(standardRefs));
            return;
        }
        AtomicBoolean verifyOrder = new AtomicBoolean(false);
        implSequence.stream().filter(BaseImpl.class::isInstance).map(BaseImpl.class::cast).forEach(typeImpl -> {
            if (typeImpl instanceof Positioned) {
                typeImpl.setStandardReference(this.getReference((Positioned)((Object)typeImpl), standard));
            } else {
                typeImpl.setStandardReference(this.getReference((BaseImpl<?>)typeImpl, standard));
                verifyOrder.set(true);
            }
        });
        if (verifyOrder.get()) {
            this.verifyOrder(standard, implSequence);
        }
    }

    EDIReference getReference(Positioned positionedTypeImpl, EDIComplexType standard) {
        List<EDIReference> standardRefs;
        int position = positionedTypeImpl.getPosition();
        int offset = position - 1;
        if (offset < (standardRefs = standard.getReferences()).size()) {
            return standardRefs.get(offset);
        }
        throw StaEDISchemaFactory.schemaException("Position " + position + " does not correspond to an entry in type " + standard.getId());
    }

    EDIReference getReference(BaseImpl<?> typeImpl, EDIComplexType standard) {
        String refTypeId = typeImpl.getTypeId();
        for (EDIReference stdRef : standard.getReferences()) {
            if (!stdRef.getReferencedType().getId().equals(refTypeId)) continue;
            return stdRef;
        }
        throw StaEDISchemaFactory.schemaException("Reference " + refTypeId + " does not correspond to an entry in type " + standard.getId());
    }

    void verifyOrder(EDIComplexType standard, List<EDITypeImplementation> implSequence) {
        Iterator standardTypes = standard.getReferences().stream().map(EDIReference::getReferencedType).map(EDIType::getId).iterator();
        String stdId = (String)standardTypes.next();
        for (EDITypeImplementation implRef : implSequence) {
            String implId = implRef.getReferencedType().getId();
            while (!implId.equals(stdId)) {
                if (standardTypes.hasNext()) {
                    stdId = (String)standardTypes.next();
                    continue;
                }
                String template = "%s reference %s is not in the correct order for the sequence of standard type %s";
                throw StaEDISchemaFactory.schemaException(String.format(template, new Object[]{implRef.getType(), implRef.getCode(), standard.getId()}));
            }
        }
    }

    List<EDITypeImplementation> getDefaultSequence(List<EDIReference> standardRefs) {
        ArrayList<EDITypeImplementation> sequence = new ArrayList<EDITypeImplementation>(standardRefs.size());
        int position = 0;
        for (EDIReference ref : standardRefs) {
            sequence.add(this.getDefaultImplementation(ref, ++position));
        }
        return sequence;
    }

    EDITypeImplementation getDefaultImplementation(EDIReference standardReference, int position) {
        EDIType std = standardReference.getReferencedType();
        switch (std.getType()) {
            case ELEMENT: {
                return new ElementImpl(standardReference, position);
            }
            case COMPOSITE: {
                return new CompositeImpl(standardReference, position, this.getDefaultSequence(((EDIComplexType)std).getReferences()));
            }
            case SEGMENT: {
                return new SegmentImpl(standardReference, this.getDefaultSequence(((EDIComplexType)std).getReferences()));
            }
            case LOOP: {
                return new LoopImpl(standardReference, this.getDefaultSequence(((EDIComplexType)std).getReferences()));
            }
        }
        throw StaEDISchemaFactory.schemaException("Implementation of " + std.getId() + " must not be empty");
    }

    LoopImplementation readImplementation(XMLStreamReader reader, QName complexType, Map<String, EDIType> types) {
        LoopImplementation loop = this.readLoopImplementation(reader, complexType, true);
        String typeId = StaEDISchema.TRANSACTION_ID;
        EDIComplexType standard = (EDIComplexType)types.get(typeId);
        TransactionImpl impl = new TransactionImpl("io.xlate.edi.internal.schema.IMPLEMENTATION", typeId, loop.getSequence());
        impl.setStandardReference(new Reference(standard, 1, 1));
        this.implementedTypes.add(impl);
        return impl;
    }

    LoopImplementation readLoopImplementation(XMLStreamReader reader, QName complexType, boolean transactionLoop) {
        String title;
        EDIElementPosition discriminatorPos;
        int maxOccurs;
        int minOccurs;
        String typeId;
        String id;
        ArrayList sequence = new ArrayList();
        if (transactionLoop) {
            id = "io.xlate.edi.internal.schema.IMPLEMENTATION";
            typeId = null;
            minOccurs = 0;
            maxOccurs = 0;
            discriminatorPos = null;
            title = null;
        } else {
            id = this.parseAttribute(reader, "code", String::valueOf);
            typeId = this.parseAttribute(reader, "type", String::valueOf);
            minOccurs = this.parseAttribute(reader, "minOccurs", Integer::parseInt, -1);
            maxOccurs = this.parseAttribute(reader, "maxOccurs", Integer::parseInt, -1);
            discriminatorPos = this.parseElementPosition(reader, ATTR_DISCRIMINATOR);
            title = this.parseAttribute(reader, "title", String::valueOf, null);
        }
        return this.readTypeImplementation(reader, () -> this.readSequence(reader, e -> this.readLoopSequenceEntry((QName)e, sequence)), descr -> this.whenExpected(reader, complexType, () -> {
            Discriminator disc = null;
            if (discriminatorPos != null) {
                SegmentImpl segImpl = (SegmentImpl)sequence.get(0);
                disc = this.buildDiscriminator(discriminatorPos, segImpl.getSequence());
            }
            return new LoopImpl(minOccurs, maxOccurs, id, typeId, disc, sequence, title, (String)descr);
        }));
    }

    void readLoopSequenceEntry(QName entryName, List<EDITypeImplementation> sequence) {
        if (entryName.equals(this.qnLoop)) {
            if (sequence.isEmpty()) {
                throw StaEDISchemaFactory.schemaException("segment element must be first child of loop sequence", this.reader);
            }
            LoopImplementation loop = this.readLoopImplementation(this.reader, entryName, false);
            this.implementedTypes.add(loop);
            sequence.add(loop);
        } else if (entryName.equals(this.qnSegment)) {
            sequence.add(this.readSegmentImplementation());
        } else {
            throw StaEDISchemaFactory.unexpectedElement(entryName, this.reader);
        }
    }

    SegmentImpl readSegmentImplementation() {
        ArrayList sequence = new ArrayList();
        String typeId = this.parseAttribute(this.reader, "type", String::valueOf);
        String code = this.parseAttribute(this.reader, "code", String::valueOf, typeId);
        int minOccurs = this.parseAttribute(this.reader, "minOccurs", Integer::parseInt, -1);
        int maxOccurs = this.parseAttribute(this.reader, "maxOccurs", Integer::parseInt, -1);
        EDIElementPosition discriminatorPos = this.parseElementPosition(this.reader, ATTR_DISCRIMINATOR);
        String title = this.parseAttribute(this.reader, "title", String::valueOf, null);
        return this.readTypeImplementation(this.reader, () -> this.readSequence(this.reader, e -> this.readPositionedSequenceEntry((QName)e, sequence, true)), descr -> this.whenExpected(this.reader, this.qnSegment, () -> {
            Discriminator disc = this.buildDiscriminator(discriminatorPos, sequence);
            SegmentImpl segment = new SegmentImpl(minOccurs, maxOccurs, typeId, code, disc, sequence, title, (String)descr);
            this.implementedTypes.add(segment);
            return segment;
        }));
    }

    void readPositionedSequenceEntry(QName entryName, List<EDITypeImplementation> sequence, boolean composites) {
        BaseImpl type;
        if (entryName.equals(this.qnElement)) {
            type = this.readElementImplementation(this.reader);
        } else if (composites && entryName.equals(this.qnComposite)) {
            type = this.readCompositeImplementation(this.reader);
        } else {
            throw StaEDISchemaFactory.unexpectedElement(entryName, this.reader);
        }
        this.implementedTypes.add(type);
        int position = ((Positioned)((Object)type)).getPosition();
        while (position > sequence.size()) {
            sequence.add(null);
        }
        EDITypeImplementation previous = sequence.set(position - 1, type);
        if (previous != null) {
            throw StaEDISchemaFactory.schemaException("Duplicate value for position " + position, this.reader);
        }
    }

    Discriminator buildDiscriminator(EDIElementPosition discriminatorPos, List<EDITypeImplementation> sequence) {
        DiscriminatorImpl disc = null;
        if (discriminatorPos != null) {
            int elementPosition = discriminatorPos.getElementPosition();
            int componentPosition = discriminatorPos.getComponentPosition();
            EDITypeImplementation eleImpl = this.getDiscriminatorElement(discriminatorPos, elementPosition, sequence, "element");
            if (eleImpl instanceof CompositeImpl) {
                sequence = ((CompositeImpl)eleImpl).getSequence();
                eleImpl = this.getDiscriminatorElement(discriminatorPos, componentPosition, sequence, "component");
            }
            if (eleImpl == null) {
                throw StaEDISchemaFactory.schemaException("Discriminator position is unused (not specified): " + discriminatorPos, this.reader);
            }
            Set<String> discValues = ((ElementImpl)eleImpl).getValueSet();
            if (!discValues.isEmpty()) {
                disc = new DiscriminatorImpl(discriminatorPos, discValues);
            } else {
                throw StaEDISchemaFactory.schemaException("Discriminator element does not specify value enumeration: " + discriminatorPos, this.reader);
            }
        }
        return disc;
    }

    EDITypeImplementation getDiscriminatorElement(EDIElementPosition discriminatorPos, int position, List<EDITypeImplementation> sequence, String type) {
        this.validatePosition(position, 1, sequence.size(), () -> "Discriminator " + type + " position invalid: " + discriminatorPos);
        return sequence.get(position - 1);
    }

    CompositeImpl readCompositeImplementation(XMLStreamReader reader) {
        ArrayList sequence = new ArrayList(5);
        int position = this.parseAttribute(reader, ATTR_POSITION, Integer::parseInt, -1);
        int minOccurs = this.parseAttribute(reader, "minOccurs", Integer::parseInt, -1);
        int maxOccurs = this.parseAttribute(reader, "maxOccurs", Integer::parseInt, -1);
        String title = this.parseAttribute(reader, "title", String::valueOf, null);
        this.validatePosition(position, 1, Integer.MAX_VALUE, () -> "Invalid position");
        return this.readTypeImplementation(reader, () -> this.readSequence(reader, e -> this.readPositionedSequenceEntry((QName)e, sequence, false)), descr -> this.whenExpected(reader, this.qnComposite, () -> new CompositeImpl(minOccurs, maxOccurs, null, position, sequence, title, (String)descr)));
    }

    void readSequence(XMLStreamReader reader, Consumer<QName> startHandler) {
        this.requireElementStart(this.qnSequence, reader);
        do {
            if (this.nextTag(reader, "reading sequence") != 1) continue;
            startHandler.accept(reader.getName());
        } while (!reader.getName().equals(this.qnSequence));
    }

    ElementImpl readElementImplementation(XMLStreamReader reader) {
        this.valueSet.clear();
        int position = this.parseAttribute(reader, ATTR_POSITION, Integer::parseInt, -1);
        int minOccurs = this.parseAttribute(reader, "minOccurs", Integer::parseInt, -1);
        int maxOccurs = this.parseAttribute(reader, "maxOccurs", Integer::parseInt, -1);
        String title = this.parseAttribute(reader, "title", String::valueOf, null);
        this.validatePosition(position, 1, Integer.MAX_VALUE, () -> "Invalid position");
        return this.readTypeImplementation(reader, () -> this.valueSet.set(super.readEnumerationValues(reader)), descr -> this.whenExpected(reader, this.qnElement, () -> new ElementImpl(minOccurs, maxOccurs, null, position, this.valueSet.get(), title, (String)descr)));
    }

    void validatePosition(int position, int min, int max, Supplier<String> message) {
        if (position < min || position > max) {
            throw StaEDISchemaFactory.schemaException(message.get(), this.reader);
        }
    }

    <T> T whenExpected(XMLStreamReader reader, QName expected, Supplier<T> supplier) {
        this.requireElement(expected, reader);
        return supplier.get();
    }

    <T> T readTypeImplementation(XMLStreamReader reader, Runnable contentHandler, Function<String, T> endHandler) {
        String descr = this.readDescription(reader);
        if (reader.getEventType() != 1) {
            return endHandler.apply(descr);
        }
        contentHandler.run();
        this.nextTag(reader, "reading type implementation end element");
        this.requireEvent(2, reader);
        return endHandler.apply(descr);
    }

    static class ValueSet {
        Map<String, String> value;

        ValueSet() {
        }

        void set(Map<String, String> value) {
            this.value = value;
        }

        Map<String, String> get() {
            return SchemaReaderBase.requireNonNullElseGet(this.value, Collections::emptyMap);
        }

        void clear() {
            this.value = null;
        }
    }
}

