/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.stream.Location;

public class TradacomsDialect
extends Dialect {
    public static final String STX = "STX";
    public static final String MHD = "MHD";
    private static final String[] EMPTY = new String[0];
    private static final int TRADACOMS_ELEMENT_OFFSET = 3;
    static final char DFLT_SEGMENT_TERMINATOR = '\'';
    static final char DFLT_DATA_ELEMENT_SEPARATOR = '+';
    static final char DFLT_COMPONENT_ELEMENT_SEPARATOR = ':';
    static final char DFLT_RELEASE_CHARACTER = '?';
    private String[] version;
    StringBuilder header;
    private int index = -1;
    private static final int TX_VERSION = 0;

    TradacomsDialect() {
        super(2, new String[1]);
        this.componentDelimiter = (char)58;
        this.elementDelimiter = (char)43;
        this.decimalMark = '\u0000';
        this.releaseIndicator = (char)63;
        this.elementRepeater = '\u0000';
        this.segmentDelimiter = (char)39;
        this.segmentTagTerminator = (char)61;
        this.clearTransactionVersion();
    }

    @Override
    public String getHeaderTag() {
        return STX;
    }

    boolean initialize(CharacterSet characters) {
        String[] parsedVersion = this.parseVersion();
        if (parsedVersion.length > 1) {
            this.version = parsedVersion;
            this.initialized = true;
            characters.setClass(this.segmentDelimiter, CharacterClass.SEGMENT_DELIMITER);
        } else {
            this.rejectionMessage = "Unable to obtain version from TRADACOMS header segment";
            this.initialized = false;
        }
        return this.initialized;
    }

    private String[] parseVersion() {
        int versionStart = 4;
        int versionEnd = this.header.indexOf(String.valueOf(this.elementDelimiter), versionStart);
        if (versionEnd - versionStart > 1) {
            return this.header.substring(versionStart, versionEnd).split('\\' + String.valueOf(this.componentDelimiter));
        }
        return EMPTY;
    }

    @Override
    public String getStandard() {
        return "TRADACOMS";
    }

    @Override
    public String[] getVersion() {
        return this.version;
    }

    @Override
    public boolean appendHeader(CharacterSet characters, char value) {
        boolean proceed = true;
        switch (++this.index) {
            case 0: {
                this.header = new StringBuilder();
                break;
            }
            case 3: {
                if (value != this.segmentTagTerminator) {
                    this.rejectionMessage = String.format("Expected TRADACOMS segment tag delimiter '%s', but found '%s'", Character.valueOf(this.segmentTagTerminator), Character.valueOf(value));
                    return false;
                }
                characters.setClass(this.segmentTagTerminator, CharacterClass.SEGMENT_TAG_DELIMITER);
                characters.setClass(this.componentDelimiter, CharacterClass.COMPONENT_DELIMITER);
                characters.setClass(this.elementDelimiter, CharacterClass.ELEMENT_DELIMITER);
                characters.setClass(this.releaseIndicator, CharacterClass.RELEASE_CHARACTER);
                break;
            }
        }
        if (characters.isIgnored(value)) {
            --this.index;
        } else {
            this.header.append(value);
            proceed = this.processInterchangeHeader(characters, value);
        }
        return proceed;
    }

    boolean processInterchangeHeader(CharacterSet characters, char value) {
        if (this.segmentDelimiter == value) {
            this.initialize(characters);
            return this.isConfirmed();
        }
        return true;
    }

    @Override
    protected void clearTransactionVersion() {
        this.transactionVersion[0] = "";
        this.updateTransactionVersionString(null);
    }

    @Override
    public void elementData(CharSequence data, Location location) {
        if (MHD.contentEquals(location.getSegmentTag())) {
            this.messageHeaderElementData(data, location);
        }
    }

    void messageHeaderElementData(CharSequence data, Location location) {
        if (location.getElementPosition() == 1) {
            this.clearTransactionVersion();
        } else if (location.getElementPosition() == 2) {
            switch (location.getComponentPosition()) {
                case 1: {
                    this.transactionType = data.toString();
                    break;
                }
                case 2: {
                    this.setTransactionVersionElement(data, 0);
                    break;
                }
            }
        }
    }
}

