/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.BasicType;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.schema.EDIType;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

class ElementType
extends BasicType
implements EDISimpleType {
    private static final String TOSTRING_FORMAT = "id: %s, type: %s, base: %s, number: %d, minLength: %d, maxLength: %d, values: %s";
    private EDISimpleType.Base base;
    private int number;
    private long minLength;
    private long maxLength;
    private Set<String> values;

    ElementType(String id, EDISimpleType.Base base, int number, long minLength, long maxLength, Set<String> values) {
        super(id, EDIType.Type.ELEMENT);
        this.base = base;
        this.number = number;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.values = Collections.unmodifiableSet(new LinkedHashSet<String>(values));
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, new Object[]{this.getId(), this.getType(), this.base, this.number, this.minLength, this.maxLength, this.values});
    }

    @Override
    public EDISimpleType.Base getBase() {
        return this.base;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public long getMinLength() {
        return this.minLength;
    }

    @Override
    public long getMaxLength() {
        return this.maxLength;
    }

    @Override
    public Set<String> getValueSet() {
        return this.values;
    }
}

