/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.ElementType;
import io.xlate.edi.internal.schema.Reference;
import io.xlate.edi.internal.schema.SchemaReader;
import io.xlate.edi.internal.schema.StaEDISchemaFactory;
import io.xlate.edi.internal.schema.StructureType;
import io.xlate.edi.internal.schema.SyntaxRestriction;
import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.schema.EDISyntaxRule;
import io.xlate.edi.schema.EDIType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

abstract class SchemaReaderBase
implements SchemaReader {
    static final String REFERR_UNDECLARED = "Type %s references undeclared %s with ref='%s'";
    static final String REFERR_ILLEGAL = "Type '%s' must not be referenced as '%s' in definition of type '%s'";
    static final String LOCALNAME_ELEMENT = "element";
    static final String LOCALNAME_COMPOSITE = "composite";
    static final EDIReference ANY_ELEMENT_REF_OPT = new Reference("io.xlate.edi.internal.schema.ANY_ELEMENT", "element", 0, 1);
    static final EDIReference ANY_COMPOSITE_REF_OPT = new Reference("io.xlate.edi.internal.schema.ANY_COMPOSITE", "composite", 0, 99);
    static final EDIReference ANY_ELEMENT_REF_REQ = new Reference("io.xlate.edi.internal.schema.ANY_ELEMENT", "element", 1, 1);
    static final EDIReference ANY_COMPOSITE_REF_REQ = new Reference("io.xlate.edi.internal.schema.ANY_COMPOSITE", "composite", 1, 99);
    static final EDISimpleType ANY_ELEMENT = new ElementType("io.xlate.edi.internal.schema.ANY_ELEMENT", EDISimpleType.Base.STRING, 0, 0L, 99999L, Collections.emptySet());
    static final EDIComplexType ANY_COMPOSITE = new StructureType("io.xlate.edi.internal.schema.ANY_COMPOSITE", EDIType.Type.COMPOSITE, "ANY", IntStream.rangeClosed(0, 99).mapToObj(i -> ANY_ELEMENT_REF_OPT).collect(Collectors.toList()), Collections.emptyList());
    final String xmlns;
    final QName qnSchema;
    final QName qnDescription;
    final QName qnInterchange;
    final QName qnGroup;
    final QName qnTransaction;
    final QName qnLoop;
    final QName qnSegment;
    final QName qnComposite;
    final QName qnElement;
    final QName qnSyntax;
    final QName qnPosition;
    final QName qnSequence;
    final QName qnEnumeration;
    final QName qnValue;
    final QName qnAny;
    final QName qnCompositeType;
    final QName qnElementType;
    final QName qnSegmentType;
    final Map<QName, EDIType.Type> complex;
    final Map<QName, EDIType.Type> typeDefinitions;
    final Set<QName> references;
    protected XMLStreamReader reader;

    public SchemaReaderBase(String xmlns, XMLStreamReader reader) {
        this.xmlns = xmlns;
        this.qnSchema = new QName(xmlns, "schema");
        this.qnDescription = new QName(xmlns, "description");
        this.qnInterchange = new QName(xmlns, "interchange");
        this.qnGroup = new QName(xmlns, "group");
        this.qnTransaction = new QName(xmlns, "transaction");
        this.qnLoop = new QName(xmlns, "loop");
        this.qnSegment = new QName(xmlns, "segment");
        this.qnComposite = new QName(xmlns, LOCALNAME_COMPOSITE);
        this.qnElement = new QName(xmlns, LOCALNAME_ELEMENT);
        this.qnSyntax = new QName(xmlns, "syntax");
        this.qnPosition = new QName(xmlns, "position");
        this.qnSequence = new QName(xmlns, "sequence");
        this.qnEnumeration = new QName(xmlns, "enumeration");
        this.qnValue = new QName(xmlns, "value");
        this.qnAny = new QName(xmlns, "any");
        this.qnCompositeType = new QName(xmlns, "compositeType");
        this.qnElementType = new QName(xmlns, "elementType");
        this.qnSegmentType = new QName(xmlns, "segmentType");
        this.complex = new HashMap<QName, EDIType.Type>(4);
        this.complex.put(this.qnInterchange, EDIType.Type.INTERCHANGE);
        this.complex.put(this.qnGroup, EDIType.Type.GROUP);
        this.complex.put(this.qnTransaction, EDIType.Type.TRANSACTION);
        this.complex.put(this.qnLoop, EDIType.Type.LOOP);
        this.complex.put(this.qnSegmentType, EDIType.Type.SEGMENT);
        this.complex.put(this.qnCompositeType, EDIType.Type.COMPOSITE);
        this.typeDefinitions = new HashMap<QName, EDIType.Type>(3);
        this.typeDefinitions.put(this.qnSegmentType, EDIType.Type.SEGMENT);
        this.typeDefinitions.put(this.qnCompositeType, EDIType.Type.COMPOSITE);
        this.typeDefinitions.put(this.qnElementType, EDIType.Type.ELEMENT);
        this.references = new HashSet<QName>(4);
        this.references.add(this.qnSegment);
        this.references.add(this.qnComposite);
        this.references.add(this.qnElement);
        this.reader = reader;
    }

    @Override
    public String getInterchangeName() {
        return this.qnInterchange.toString();
    }

    @Override
    public String getTransactionName() {
        return this.qnTransaction.toString();
    }

    @Override
    public Map<String, EDIType> readTypes() throws EDISchemaException {
        HashMap<String, EDIType> types = new HashMap<String, EDIType>(100);
        types.put("io.xlate.edi.internal.schema.ANY_ELEMENT", ANY_ELEMENT);
        types.put("io.xlate.edi.internal.schema.ANY_COMPOSITE", ANY_COMPOSITE);
        try {
            if (this.isInterchangeSchema(this.reader)) {
                this.readInterchange(this.reader, types);
            } else {
                this.readTransaction(this.reader, types);
            }
            this.readTypeDefinitions(this.reader, types);
            this.setReferences(types);
            this.reader.next();
            this.requireEvent(8, this.reader);
        }
        catch (XMLStreamException e) {
            throw new EDISchemaException(e);
        }
        return types;
    }

    boolean isInterchangeSchema(XMLStreamReader reader) throws XMLStreamException {
        reader.nextTag();
        QName element = reader.getName();
        if (!this.qnInterchange.equals(element) && !this.qnTransaction.equals(element)) {
            throw StaEDISchemaFactory.unexpectedElement(element, reader);
        }
        return this.qnInterchange.equals(element);
    }

    String readDescription(XMLStreamReader reader) throws XMLStreamException {
        reader.nextTag();
        QName element = reader.getName();
        String description = null;
        if (this.qnDescription.equals(element)) {
            description = reader.getElementText();
            reader.nextTag();
        }
        return description;
    }

    void readInterchange(XMLStreamReader reader, Map<String, EDIType> types) throws XMLStreamException {
        Reference headerRef = this.createControlReference(reader, "header");
        Reference trailerRef = this.createControlReference(reader, "trailer");
        this.readDescription(reader);
        QName element = reader.getName();
        if (!this.qnSequence.equals(element)) {
            throw StaEDISchemaFactory.unexpectedElement(element, reader);
        }
        reader.nextTag();
        element = reader.getName();
        ArrayList<EDIReference> refs = new ArrayList<EDIReference>(3);
        refs.add(headerRef);
        while (this.qnSegment.equals(element)) {
            this.addReferences(reader, EDIType.Type.SEGMENT, refs, this.readReference(reader, types));
            reader.nextTag();
            reader.nextTag();
            element = reader.getName();
        }
        if (this.qnGroup.equals(element)) {
            refs.add(this.readControlStructure(reader, element, this.qnTransaction, types));
            reader.nextTag();
            reader.nextTag();
            element = reader.getName();
        }
        if (this.qnTransaction.equals(element)) {
            refs.add(this.readControlStructure(reader, element, null, types));
            reader.nextTag();
            reader.nextTag();
        }
        refs.add(trailerRef);
        StructureType interchange = new StructureType(this.qnInterchange.toString(), EDIType.Type.INTERCHANGE, "INTERCHANGE", refs, Collections.emptyList());
        types.put(interchange.getId(), interchange);
    }

    Reference readControlStructure(XMLStreamReader reader, QName element, QName subelement, Map<String, EDIType> types) throws XMLStreamException {
        String use;
        int minOccurs = 0;
        int maxOccurs = 99999;
        switch (use = this.parseAttribute(reader, "use", String::valueOf, "optional")) {
            case "required": {
                minOccurs = 1;
                break;
            }
            case "optional": {
                minOccurs = 0;
                break;
            }
            case "prohibited": {
                maxOccurs = 0;
                break;
            }
            default: {
                throw StaEDISchemaFactory.schemaException("Invalid value for 'use': " + use, reader);
            }
        }
        Reference headerRef = this.createControlReference(reader, "header");
        Reference trailerRef = this.createControlReference(reader, "trailer");
        this.readDescription(reader);
        if (subelement != null) {
            this.requireElementStart(subelement, reader);
        }
        ArrayList<EDIReference> refs = new ArrayList<EDIReference>(3);
        refs.add(headerRef);
        if (subelement != null) {
            refs.add(this.readControlStructure(reader, subelement, null, types));
        }
        refs.add(trailerRef);
        StructureType struct = new StructureType(element.toString(), this.complex.get(element), this.complex.get(element).toString(), refs, Collections.emptyList());
        types.put(struct.getId(), struct);
        Reference structRef = new Reference(struct.getId(), element.getLocalPart(), minOccurs, maxOccurs);
        structRef.setReferencedType(struct);
        return structRef;
    }

    Reference createControlReference(XMLStreamReader reader, String attributeName) {
        String refId = this.parseAttribute(reader, attributeName, String::valueOf);
        return new Reference(refId, "segment", 1, 1);
    }

    void readTransaction(XMLStreamReader reader, Map<String, EDIType> types) throws XMLStreamException {
        QName element = reader.getName();
        types.put(this.qnTransaction.toString(), this.readComplexType(reader, element, types));
    }

    void readTypeDefinitions(XMLStreamReader reader, Map<String, EDIType> types) throws XMLStreamException {
        boolean schemaEnd = false;
        if (this.typeDefinitions.containsKey(reader.getName()) && reader.getEventType() == 1) {
            this.readTypeDefinition(types, reader);
        }
        block4: while (reader.hasNext() && !schemaEnd) {
            switch (reader.next()) {
                case 1: {
                    this.readTypeDefinition(types, reader);
                    continue block4;
                }
                case 2: {
                    if (!reader.getName().equals(this.qnSchema)) continue block4;
                    schemaEnd = true;
                    continue block4;
                }
            }
            this.checkEvent(reader, new int[0]);
        }
    }

    void readTypeDefinition(Map<String, EDIType> types, XMLStreamReader reader) throws XMLStreamException {
        QName element = reader.getName();
        if (this.complex.containsKey(element)) {
            String name = this.parseAttribute(reader, "name", String::valueOf);
            this.nameCheck(name, types, reader);
            types.put(name, this.readComplexType(reader, element, types));
        } else if (this.qnElementType.equals(element)) {
            String name = this.parseAttribute(reader, "name", String::valueOf);
            this.nameCheck(name, types, reader);
            types.put(name, this.readSimpleType(reader));
        } else {
            throw StaEDISchemaFactory.unexpectedElement(element, reader);
        }
    }

    void nameCheck(String name, Map<String, EDIType> types, XMLStreamReader reader) {
        if (types.containsKey(name)) {
            throw StaEDISchemaFactory.schemaException("duplicate name: " + name, reader);
        }
    }

    StructureType readComplexType(XMLStreamReader reader, QName complexType, Map<String, EDIType> types) throws XMLStreamException {
        String id;
        EDIType.Type type = this.complex.get(complexType);
        String code = this.parseAttribute(reader, "code", String::valueOf, null);
        if (this.qnTransaction.equals(complexType)) {
            id = this.qnTransaction.toString();
        } else if (this.qnLoop.equals(complexType)) {
            id = code;
        } else {
            id = this.parseAttribute(reader, "name", String::valueOf);
            if (type == EDIType.Type.SEGMENT && !id.matches("^[A-Z][A-Z0-9]{1,2}$")) {
                throw StaEDISchemaFactory.schemaException("Invalid segment name [" + id + ']', reader);
            }
        }
        if (code == null) {
            code = id;
        }
        ArrayList<EDIReference> refs = new ArrayList<EDIReference>(8);
        ArrayList<EDISyntaxRule> rules = new ArrayList<EDISyntaxRule>(2);
        this.readDescription(reader);
        this.requireElementStart(this.qnSequence, reader);
        this.readReferences(reader, types, type, refs);
        int event = reader.nextTag();
        if (event == 1) {
            this.requireElementStart(this.qnSyntax, reader);
            do {
                this.readSyntax(reader, rules);
            } while ((event = reader.nextTag()) == 1 && this.qnSyntax.equals(reader.getName()));
        }
        if (event == 2) {
            return new StructureType(id, type, code, refs, rules);
        }
        throw StaEDISchemaFactory.unexpectedEvent(reader);
    }

    void readReferences(XMLStreamReader reader, Map<String, EDIType> types, EDIType.Type parentType, List<EDIReference> refs) {
        try {
            block6: while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        this.addReferences(reader, parentType, refs, this.readReference(reader, types));
                        continue block6;
                    }
                    case 2: {
                        if (!reader.getName().equals(this.qnSequence)) continue block6;
                        return;
                    }
                }
                this.checkEvent(reader, new int[0]);
            }
        }
        catch (XMLStreamException xse) {
            throw StaEDISchemaFactory.schemaException("Exception reading sequence", reader, xse);
        }
    }

    void addReferences(XMLStreamReader reader, EDIType.Type parentType, List<EDIReference> refs, Reference reference) {
        if ("ANY".equals(reference.getRefId())) {
            EDIReference reqRef;
            EDIReference optRef;
            switch (parentType) {
                case SEGMENT: {
                    optRef = ANY_COMPOSITE_REF_OPT;
                    reqRef = ANY_COMPOSITE_REF_REQ;
                    break;
                }
                case COMPOSITE: {
                    optRef = ANY_ELEMENT_REF_OPT;
                    reqRef = ANY_ELEMENT_REF_REQ;
                    break;
                }
                default: {
                    throw StaEDISchemaFactory.schemaException("Element " + this.qnAny + " may only be present for segmentType and compositeType", reader);
                }
            }
            int min = reference.getMinOccurs();
            int max = reference.getMaxOccurs();
            for (int i = 0; i < max; ++i) {
                refs.add(i < min ? reqRef : optRef);
            }
        } else {
            refs.add(reference);
        }
    }

    Reference readReference(XMLStreamReader reader, Map<String, EDIType> types) {
        Reference ref;
        QName element = reader.getName();
        String refId = null;
        if (this.qnAny.equals(element)) {
            refId = "ANY";
        } else if (this.references.contains(element)) {
            refId = this.readReferencedId(reader);
            Objects.requireNonNull(refId);
        } else if (this.qnLoop.equals(element)) {
            refId = this.parseAttribute(reader, "code", String::valueOf);
        } else {
            throw StaEDISchemaFactory.unexpectedElement(element, reader);
        }
        String refTag = element.getLocalPart();
        int minOccurs = this.parseAttribute(reader, "minOccurs", Integer::parseInt, 0);
        int maxOccurs = this.parseAttribute(reader, "maxOccurs", Integer::parseInt, 1);
        if (this.qnLoop.equals(element)) {
            StructureType loop;
            try {
                loop = this.readComplexType(reader, element, types);
            }
            catch (XMLStreamException xse) {
                throw StaEDISchemaFactory.schemaException("Exception reading loop", reader, xse);
            }
            String loopRefId = this.qnLoop.toString() + '.' + refId;
            types.put(loopRefId, loop);
            ref = new Reference(loopRefId, refTag, minOccurs, maxOccurs);
            ref.setReferencedType(loop);
        } else {
            ref = new Reference(refId, refTag, minOccurs, maxOccurs);
        }
        return ref;
    }

    void readSyntax(XMLStreamReader reader, List<EDISyntaxRule> rules) {
        String type = this.parseAttribute(reader, "type", String::valueOf);
        EDISyntaxRule.Type typeInt = null;
        try {
            typeInt = EDISyntaxRule.Type.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw StaEDISchemaFactory.schemaException("Invalid syntax 'type': [" + type + ']', reader, e);
        }
        try {
            rules.add(new SyntaxRestriction(typeInt, this.readSyntaxPositions(reader)));
        }
        catch (XMLStreamException xse) {
            throw StaEDISchemaFactory.schemaException("Exception reading syntax", reader, xse);
        }
    }

    List<Integer> readSyntaxPositions(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<Integer> positions = new ArrayList<Integer>(5);
        block6: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    QName element = reader.getName();
                    if (!this.qnPosition.equals(element)) continue block6;
                    String position = reader.getElementText();
                    try {
                        positions.add(Integer.parseInt(position));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw StaEDISchemaFactory.schemaException("invalid position", reader);
                    }
                }
                case 2: {
                    if (!this.qnSyntax.equals(reader.getName())) continue block6;
                    return positions;
                }
                default: {
                    this.checkEvent(reader, new int[0]);
                }
            }
        }
        throw StaEDISchemaFactory.schemaException("missing end element " + this.qnSyntax, reader);
    }

    ElementType readSimpleType(XMLStreamReader reader) throws XMLStreamException {
        String name = this.parseAttribute(reader, "name", String::valueOf);
        String base = this.parseAttribute(reader, "base", String::valueOf, EDISimpleType.Base.STRING.toString());
        EDISimpleType.Base intBase = null;
        try {
            intBase = EDISimpleType.Base.valueOf(base.toUpperCase());
        }
        catch (Exception e) {
            throw StaEDISchemaFactory.schemaException("Invalid element 'type': [" + base + ']', reader, e);
        }
        int number = this.parseAttribute(reader, "number", Integer::parseInt, -1);
        long minLength = this.parseAttribute(reader, "minLength", Long::parseLong, 1L);
        long maxLength = this.parseAttribute(reader, "maxLength", Long::parseLong, 1L);
        Set<String> values = intBase == EDISimpleType.Base.IDENTIFIER ? this.readEnumerationValues(reader) : Collections.emptySet();
        return new ElementType(name, intBase, number, minLength, maxLength, values);
    }

    Set<String> readEnumerationValues(XMLStreamReader reader) throws XMLStreamException {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        boolean enumerationEnd = false;
        block4: while (reader.hasNext() && !enumerationEnd) {
            switch (reader.next()) {
                case 1: {
                    QName element = reader.getName();
                    if (element.equals(this.qnValue)) {
                        values.add(reader.getElementText());
                        continue block4;
                    }
                    if (element.equals(this.qnEnumeration)) continue block4;
                    throw StaEDISchemaFactory.unexpectedElement(element, reader);
                }
                case 2: {
                    if (!reader.getName().equals(this.qnEnumeration)) continue block4;
                    enumerationEnd = true;
                    continue block4;
                }
            }
        }
        return values;
    }

    <T> T parseAttribute(XMLStreamReader reader, String attrName, Function<String, T> converter, T defaultValue) {
        String attr = reader.getAttributeValue(null, attrName);
        try {
            return attr != null ? converter.apply(attr) : defaultValue;
        }
        catch (Exception e) {
            throw StaEDISchemaFactory.schemaException("Invalid " + attrName, reader, e);
        }
    }

    <T> T parseAttribute(XMLStreamReader reader, String attrName, Function<String, T> converter) {
        String attr = reader.getAttributeValue(null, attrName);
        if (attr != null) {
            try {
                return converter.apply(attr);
            }
            catch (Exception e) {
                throw StaEDISchemaFactory.schemaException("Invalid " + attrName, reader, e);
            }
        }
        throw StaEDISchemaFactory.schemaException("Missing required attribute: [" + attrName + ']', reader);
    }

    void requireEvent(int eventId, XMLStreamReader reader) {
        Integer event = reader.getEventType();
        if (event != eventId) {
            throw StaEDISchemaFactory.unexpectedEvent(reader);
        }
    }

    void requireElementStart(QName element, XMLStreamReader reader) {
        Integer event = reader.getEventType();
        if (event != 1) {
            throw StaEDISchemaFactory.schemaException("Expected XML element [" + element + "] not found", reader);
        }
        if (!element.equals(reader.getName())) {
            throw StaEDISchemaFactory.schemaException("Unexpected XML element [" + reader.getName() + "]", reader);
        }
    }

    void checkEvent(XMLStreamReader reader, int ... expected) {
        Integer event = reader.getEventType();
        if (Arrays.stream(expected).anyMatch(event::equals)) {
            return;
        }
        switch (event) {
            case 4: 
            case 6: {
                String text = reader.getText().trim();
                if (text.length() <= 0) break;
                throw StaEDISchemaFactory.schemaException("Unexpected XML [" + text + "]", reader);
            }
            case 5: {
                break;
            }
            default: {
                throw StaEDISchemaFactory.schemaException("Unexpected XML event [" + event + ']', reader);
            }
        }
    }

    void setReferences(Map<String, EDIType> types) {
        types.values().stream().filter(type -> type instanceof StructureType).forEach(struct -> this.setReferences((StructureType)struct, types));
    }

    void setReferences(StructureType struct, Map<String, EDIType> types) {
        for (EDIReference ref : struct.getReferences()) {
            Reference impl = (Reference)ref;
            EDIType target = types.get(impl.getRefId());
            if (target == null) {
                throw StaEDISchemaFactory.schemaException(String.format(REFERR_UNDECLARED, struct.getId(), impl.getRefTag(), impl.getRefId()));
            }
            EDIType.Type refType = target.getType();
            if (refType != EDIType.Type.valueOf(impl.getRefTag().toUpperCase())) {
                throw StaEDISchemaFactory.schemaException(String.format(REFERR_ILLEGAL, impl.getRefId(), impl.getRefTag(), struct.getId()));
            }
            impl.setReferencedType(target);
        }
    }

    protected abstract String readReferencedId(XMLStreamReader var1);
}

