/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.Reference;
import io.xlate.edi.internal.schema.SchemaReader;
import io.xlate.edi.internal.schema.SchemaReaderBase;
import io.xlate.edi.internal.schema.StaEDISchemaFactory;
import io.xlate.edi.internal.schema.implementation.BaseComplexImpl;
import io.xlate.edi.internal.schema.implementation.BaseImpl;
import io.xlate.edi.internal.schema.implementation.CompositeImpl;
import io.xlate.edi.internal.schema.implementation.DiscriminatorImpl;
import io.xlate.edi.internal.schema.implementation.ElementImpl;
import io.xlate.edi.internal.schema.implementation.LoopImpl;
import io.xlate.edi.internal.schema.implementation.Positioned;
import io.xlate.edi.internal.schema.implementation.SegmentImpl;
import io.xlate.edi.internal.schema.implementation.TransactionImpl;
import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.implementation.Discriminator;
import io.xlate.edi.schema.implementation.EDITypeImplementation;
import io.xlate.edi.schema.implementation.LoopImplementation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class SchemaReaderV3
extends SchemaReaderBase
implements SchemaReader {
    private static final Logger LOGGER = Logger.getLogger(SchemaReaderV3.class.getName());
    private static final String ATTR_MIN_OCCURS = "minOccurs";
    private static final String ATTR_MAX_OCCURS = "maxOccurs";
    private static final String ATTR_POSITION = "position";
    private static final String ATTR_DISCRIMINATOR = "discriminator";
    private static final String ATTR_TITLE = "title";
    final QName qnImplementation;
    final Deque<EDITypeImplementation> implementedTypes = new LinkedList<EDITypeImplementation>();

    public SchemaReaderV3(XMLStreamReader reader) {
        super("http://xlate.io/EDISchema/v3", reader);
        this.qnImplementation = new QName(this.xmlns, "implementation");
    }

    @Override
    public String getImplementationName() {
        return this.qnImplementation.toString();
    }

    @Override
    protected String readReferencedId(XMLStreamReader reader) {
        String id = reader.getAttributeValue(null, "type");
        if (id == null && (id = reader.getAttributeValue(null, "ref")) != null) {
            Location parseLocation = reader.getLocation();
            LOGGER.warning("Attribute 'ref' is deprecated at line " + parseLocation.getLineNumber() + ", column " + parseLocation.getColumnNumber());
        }
        return id;
    }

    @Override
    void readTransaction(XMLStreamReader reader, Map<String, EDIType> types) throws XMLStreamException {
        super.readTransaction(reader, types);
        reader.nextTag();
        QName element = reader.getName();
        LoopImplementation impl = this.readImplementation(reader, element, types);
        if (impl != null) {
            types.put(this.qnImplementation.toString(), impl);
        }
    }

    @Override
    void setReferences(Map<String, EDIType> types) {
        super.setReferences(types);
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.implementedTypes.descendingIterator(), 16), false).filter(type -> type.getType() != EDIType.Type.ELEMENT).map(type -> (BaseComplexImpl)type).forEach(type -> this.setReferences((BaseComplexImpl)type, types));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setReferences(BaseComplexImpl type, Map<String, EDIType> types) {
        String typeId = type.getType() == EDIType.Type.LOOP ? this.qnLoop.toString() + '.' + type.getTypeId() : type.getTypeId();
        EDIComplexType standard = (EDIComplexType)types.get(typeId);
        List<EDIReference> standardRefs = standard.getReferences();
        List<EDITypeImplementation> implSequence = type.getSequence();
        if (implSequence.isEmpty()) {
            implSequence.addAll(this.getDefaultSequence(standardRefs));
            return;
        }
        for (EDITypeImplementation t : implSequence) {
            EDIReference stdRef;
            if (t == null) continue;
            BaseImpl seqImpl = (BaseImpl)t;
            if (t instanceof Positioned) {
                Positioned p = (Positioned)((Object)t);
                int offset = p.getPosition() - 1;
                if (standardRefs == null || offset <= -1 || offset >= standardRefs.size()) throw StaEDISchemaFactory.schemaException("Position " + p.getPosition() + " does not correspond to an entry in type " + standard.getId());
                stdRef = standardRefs.get(offset);
            } else {
                String refTypeId = seqImpl.getTypeId();
                stdRef = standardRefs.stream().filter(r -> r.getReferencedType().getId().equals(refTypeId)).findFirst().orElseThrow(() -> StaEDISchemaFactory.schemaException("Reference " + refTypeId + " does not correspond to an entry in type " + standard.getId()));
            }
            seqImpl.setStandardReference(stdRef);
        }
    }

    List<EDITypeImplementation> getDefaultSequence(List<EDIReference> standardRefs) {
        ArrayList<EDITypeImplementation> sequence = new ArrayList<EDITypeImplementation>(standardRefs.size());
        int position = 0;
        for (EDIReference ref : standardRefs) {
            sequence.add(this.getDefaultImplementation(ref, ++position));
        }
        return sequence;
    }

    EDITypeImplementation getDefaultImplementation(EDIReference standardReference, int position) {
        EDIType std = standardReference.getReferencedType();
        switch (std.getType()) {
            case ELEMENT: {
                return new ElementImpl(standardReference, position);
            }
            case COMPOSITE: {
                return new CompositeImpl(standardReference, position, this.getDefaultSequence(((EDIComplexType)std).getReferences()));
            }
        }
        throw StaEDISchemaFactory.schemaException("Implementation of " + std.getId() + " must not be empty");
    }

    LoopImplementation readImplementation(XMLStreamReader reader, QName complexType, Map<String, EDIType> types) throws XMLStreamException {
        if (!this.qnImplementation.equals(complexType)) {
            return null;
        }
        LoopImplementation loop = this.readLoopImplementation(reader, complexType, true);
        String typeId = this.qnTransaction.toString();
        EDIComplexType standard = (EDIComplexType)types.get(typeId);
        TransactionImpl impl = new TransactionImpl(this.qnImplementation.toString(), typeId, loop.getSequence());
        impl.setStandardReference(new Reference(standard, 1, 1));
        this.implementedTypes.add(impl);
        return impl;
    }

    LoopImplementation readLoopImplementation(XMLStreamReader reader, QName complexType, boolean transactionLoop) throws XMLStreamException {
        String typeId;
        String id;
        ArrayList<EDITypeImplementation> sequence = new ArrayList<EDITypeImplementation>();
        int minOccurs = 0;
        int maxOccurs = 0;
        BigDecimal discriminatorAttr = null;
        String title = null;
        String descr = null;
        if (transactionLoop) {
            id = this.qnImplementation.toString();
            typeId = null;
        } else {
            id = this.parseAttribute(reader, "code", String::valueOf);
            typeId = this.parseAttribute(reader, "type", String::valueOf);
            minOccurs = this.parseAttribute(reader, ATTR_MIN_OCCURS, Integer::parseInt, -1);
            maxOccurs = this.parseAttribute(reader, ATTR_MAX_OCCURS, Integer::parseInt, -1);
            discriminatorAttr = this.parseAttribute(reader, ATTR_DISCRIMINATOR, BigDecimal::new, null);
            title = this.parseAttribute(reader, ATTR_TITLE, String::valueOf, null);
        }
        if (reader.nextTag() != 1) {
            throw StaEDISchemaFactory.unexpectedEvent(reader);
        }
        descr = this.readImplDescription(reader);
        this.readSequence(reader, e -> this.readLoopSequenceEntry((QName)e, (List<EDITypeImplementation>)sequence));
        if (reader.nextTag() == 2) {
            QName element = reader.getName();
            if (element.equals(complexType)) {
                Discriminator disc = null;
                if (discriminatorAttr != null) {
                    SegmentImpl segImpl = (SegmentImpl)sequence.get(0);
                    disc = this.buildDiscriminator(discriminatorAttr, segImpl.getSequence());
                }
                return new LoopImpl(minOccurs, maxOccurs, id, typeId, disc, sequence, title, descr);
            }
            throw StaEDISchemaFactory.unexpectedElement(element, reader);
        }
        throw StaEDISchemaFactory.unexpectedEvent(reader);
    }

    void readLoopSequenceEntry(QName entryName, List<EDITypeImplementation> sequence) {
        block5: {
            try {
                if (entryName.equals(this.qnLoop)) {
                    if (sequence.isEmpty()) {
                        throw StaEDISchemaFactory.schemaException("segment element must be first child of loop sequence", this.reader);
                    }
                    LoopImplementation loop = this.readLoopImplementation(this.reader, entryName, false);
                    this.implementedTypes.add(loop);
                    sequence.add(loop);
                    break block5;
                }
                if (entryName.equals(this.qnSegment)) {
                    sequence.add(this.readSegmentImplementation());
                    break block5;
                }
                throw StaEDISchemaFactory.unexpectedElement(entryName, this.reader);
            }
            catch (XMLStreamException xse) {
                throw StaEDISchemaFactory.schemaException("Exception reading loop sequence", this.reader, xse);
            }
        }
    }

    SegmentImpl readSegmentImplementation() throws XMLStreamException {
        ArrayList<EDITypeImplementation> sequence = new ArrayList<EDITypeImplementation>();
        String typeId = this.parseAttribute(this.reader, "type", String::valueOf);
        int minOccurs = this.parseAttribute(this.reader, ATTR_MIN_OCCURS, Integer::parseInt, -1);
        int maxOccurs = this.parseAttribute(this.reader, ATTR_MAX_OCCURS, Integer::parseInt, -1);
        BigDecimal discriminatorAttr = this.parseAttribute(this.reader, ATTR_DISCRIMINATOR, BigDecimal::new, null);
        String title = this.parseAttribute(this.reader, ATTR_TITLE, String::valueOf, null);
        String descr = null;
        int event = this.reader.nextTag();
        if (event != 1) {
            if (event == 2) {
                return this.newSegmentImpl(minOccurs, maxOccurs, typeId, discriminatorAttr, sequence, title, null);
            }
            throw StaEDISchemaFactory.unexpectedEvent(this.reader);
        }
        descr = this.readImplDescription(this.reader);
        this.readSequence(this.reader, e -> this.readPositionedSequenceEntry((QName)e, (List<EDITypeImplementation>)sequence, true));
        if (this.reader.nextTag() == 2) {
            return this.newSegmentImpl(minOccurs, maxOccurs, typeId, discriminatorAttr, sequence, title, descr);
        }
        throw StaEDISchemaFactory.unexpectedEvent(this.reader);
    }

    void readPositionedSequenceEntry(QName entryName, List<EDITypeImplementation> sequence, boolean composites) {
        BaseImpl type;
        block6: {
            try {
                if (entryName.equals(this.qnElement)) {
                    type = this.readElementImplementation(this.reader);
                    break block6;
                }
                if (composites && entryName.equals(this.qnComposite)) {
                    type = this.readCompositeImplementation(this.reader);
                    break block6;
                }
                throw StaEDISchemaFactory.unexpectedElement(entryName, this.reader);
            }
            catch (XMLStreamException xse) {
                throw StaEDISchemaFactory.schemaException("Exception reading segment sequence", this.reader, xse);
            }
        }
        this.implementedTypes.add(type);
        int position = ((Positioned)((Object)type)).getPosition();
        while (position > sequence.size()) {
            sequence.add(null);
        }
        EDITypeImplementation previous = sequence.set(position - 1, type);
        if (previous != null) {
            throw StaEDISchemaFactory.schemaException("Duplicate value for position " + position, this.reader);
        }
    }

    SegmentImpl newSegmentImpl(int minOccurs, int maxOccurs, String typeId, BigDecimal discriminatorAttr, List<EDITypeImplementation> sequence, String title, String descr) {
        QName element = this.reader.getName();
        if (element.equals(this.qnSegment)) {
            Discriminator disc = this.buildDiscriminator(discriminatorAttr, sequence);
            SegmentImpl segment = new SegmentImpl(minOccurs, maxOccurs, typeId, disc, sequence, title, descr);
            this.implementedTypes.add(segment);
            return segment;
        }
        throw StaEDISchemaFactory.unexpectedElement(element, this.reader);
    }

    Discriminator buildDiscriminator(BigDecimal discriminatorAttr, List<EDITypeImplementation> sequence) {
        DiscriminatorImpl disc = null;
        if (discriminatorAttr != null) {
            int elementPosition = discriminatorAttr.intValue();
            int componentPosition = discriminatorAttr.remainder(BigDecimal.ONE).movePointRight(discriminatorAttr.scale()).intValue();
            EDITypeImplementation eleImpl = this.getDiscriminatorElement(discriminatorAttr, elementPosition, sequence, "element");
            if (eleImpl instanceof CompositeImpl) {
                sequence = ((CompositeImpl)eleImpl).getSequence();
                eleImpl = this.getDiscriminatorElement(discriminatorAttr, componentPosition, sequence, "component");
            }
            if (eleImpl == null) {
                throw StaEDISchemaFactory.schemaException("Discriminator position is unused (not specified): " + discriminatorAttr, this.reader);
            }
            Set<String> valueSet = ((ElementImpl)eleImpl).getValueSet();
            if (!valueSet.isEmpty()) {
                disc = new DiscriminatorImpl(elementPosition, componentPosition, valueSet);
            } else {
                throw StaEDISchemaFactory.schemaException("Discriminator element does not specify value enumeration: " + discriminatorAttr, this.reader);
            }
        }
        return disc;
    }

    EDITypeImplementation getDiscriminatorElement(BigDecimal attr, int position, List<EDITypeImplementation> sequence, String type) {
        if (position > 0 && position <= sequence.size()) {
            return sequence.get(position - 1);
        }
        throw StaEDISchemaFactory.schemaException("Discriminator " + type + " position invalid: " + attr, this.reader);
    }

    CompositeImpl readCompositeImplementation(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<EDITypeImplementation> sequence = new ArrayList<EDITypeImplementation>();
        int position = this.parseAttribute(reader, ATTR_POSITION, Integer::parseInt, 0);
        int minOccurs = this.parseAttribute(reader, ATTR_MIN_OCCURS, Integer::parseInt, 0);
        int maxOccurs = this.parseAttribute(reader, ATTR_MAX_OCCURS, Integer::parseInt, 0);
        String title = this.parseAttribute(reader, ATTR_TITLE, String::valueOf, null);
        String descr = null;
        int event = reader.nextTag();
        if (event != 1) {
            if (event == 2) {
                return this.newCompositeImpl(reader, minOccurs, maxOccurs, position, sequence, title, null);
            }
            throw StaEDISchemaFactory.unexpectedEvent(reader);
        }
        descr = this.readImplDescription(reader);
        this.readSequence(reader, e -> this.readPositionedSequenceEntry((QName)e, (List<EDITypeImplementation>)sequence, false));
        if (reader.nextTag() == 2) {
            return this.newCompositeImpl(reader, minOccurs, maxOccurs, position, sequence, title, descr);
        }
        throw StaEDISchemaFactory.unexpectedEvent(reader);
    }

    CompositeImpl newCompositeImpl(XMLStreamReader reader, int minOccurs, int maxOccurs, int position, List<EDITypeImplementation> sequence, String title, String descr) {
        QName element = reader.getName();
        if (element.equals(this.qnComposite)) {
            return new CompositeImpl(minOccurs, maxOccurs, null, position, sequence, title, descr);
        }
        throw StaEDISchemaFactory.unexpectedElement(element, reader);
    }

    void readSequence(XMLStreamReader reader, Consumer<QName> startHandler) throws XMLStreamException {
        QName element = reader.getName();
        if (element.equals(this.qnSequence)) {
            boolean endOfType = false;
            block4: while (!endOfType && reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        startHandler.accept(reader.getName());
                        continue block4;
                    }
                    case 2: {
                        if (!reader.getName().equals(element)) continue block4;
                        endOfType = true;
                        continue block4;
                    }
                }
                this.checkEvent(reader, new int[0]);
            }
        } else {
            throw StaEDISchemaFactory.unexpectedElement(element, reader);
        }
    }

    ElementImpl readElementImplementation(XMLStreamReader reader) throws XMLStreamException {
        Set<String> valueSet = Collections.emptySet();
        int position = this.parseAttribute(reader, ATTR_POSITION, Integer::parseInt, 0);
        int minOccurs = this.parseAttribute(reader, ATTR_MIN_OCCURS, Integer::parseInt, 0);
        int maxOccurs = this.parseAttribute(reader, ATTR_MAX_OCCURS, Integer::parseInt, 0);
        String title = this.parseAttribute(reader, ATTR_TITLE, String::valueOf, null);
        String descr = null;
        int event = reader.nextTag();
        if (event == 1) {
            descr = this.readImplDescription(reader);
            QName element = reader.getName();
            if (!element.equals(this.qnEnumeration)) {
                throw StaEDISchemaFactory.unexpectedElement(element, reader);
            }
        } else {
            if (event == 2) {
                return this.newElementImpl(reader, minOccurs, maxOccurs, position, valueSet, title, null);
            }
            throw StaEDISchemaFactory.unexpectedEvent(reader);
        }
        valueSet = super.readEnumerationValues(reader);
        if (reader.nextTag() == 2) {
            return this.newElementImpl(reader, minOccurs, maxOccurs, position, valueSet, title, descr);
        }
        throw StaEDISchemaFactory.unexpectedEvent(reader);
    }

    ElementImpl newElementImpl(XMLStreamReader reader, int minOccurs, int maxOccurs, int position, Set<String> valueSet, String title, String descr) {
        QName element = reader.getName();
        if (element.equals(this.qnElement)) {
            return new ElementImpl(minOccurs, maxOccurs, null, position, valueSet, title, descr);
        }
        throw StaEDISchemaFactory.unexpectedElement(element, reader);
    }

    String readImplDescription(XMLStreamReader reader) throws XMLStreamException {
        QName element = reader.getName();
        String description = null;
        if (element.equals(this.qnDescription)) {
            description = reader.getElementText();
            reader.nextTag();
            this.checkEvent(reader, 1);
        }
        return description;
    }
}

