/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.schema.EDISyntaxRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class SyntaxRestriction
implements EDISyntaxRule {
    private static final String TOSTRING_FORMAT = "type: %s, positions: %s";
    private EDISyntaxRule.Type type;
    private List<Integer> positions;

    SyntaxRestriction(EDISyntaxRule.Type type, List<Integer> positions) {
        Objects.requireNonNull(type, "syntax rule type must not be null");
        Objects.requireNonNull(positions, "syntax rule positions must not be null");
        if (positions.isEmpty()) {
            throw new IllegalArgumentException("syntax rule positions must not be em");
        }
        this.type = type;
        this.positions = new ArrayList<Integer>(positions);
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, new Object[]{this.type, this.positions});
    }

    @Override
    public EDISyntaxRule.Type getType() {
        return this.type;
    }

    @Override
    public List<Integer> getPositions() {
        return this.positions;
    }
}

