/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.stream.LocationView;
import io.xlate.edi.stream.Location;

public class StaEDIStreamLocation
extends LocationView
implements Location {
    private boolean repeated = false;

    public StaEDIStreamLocation() {
    }

    public StaEDIStreamLocation(Location source) {
        super(source);
    }

    public StaEDIStreamLocation copy() {
        StaEDIStreamLocation copy = new StaEDIStreamLocation();
        copy.lineNumber = this.lineNumber;
        copy.columnNumber = this.columnNumber;
        copy.characterOffset = this.characterOffset;
        copy.segmentPosition = this.segmentPosition;
        copy.segmentTag = this.segmentTag;
        copy.elementPosition = this.elementPosition;
        copy.elementOccurrence = this.elementOccurrence;
        copy.componentPosition = this.componentPosition;
        copy.repeated = this.repeated;
        return copy;
    }

    public void set(Location source) {
        this.lineNumber = source.getLineNumber();
        this.columnNumber = source.getColumnNumber();
        this.characterOffset = source.getCharacterOffset();
        this.segmentPosition = source.getSegmentPosition();
        this.segmentTag = source.getSegmentTag();
        this.elementPosition = source.getElementPosition();
        this.componentPosition = source.getComponentPosition();
        this.elementOccurrence = source.getElementOccurrence();
    }

    public void setElementPosition(int elementPosition) {
        this.elementPosition = elementPosition;
    }

    public void setElementOccurrence(int elementOccurrence) {
        this.elementOccurrence = elementOccurrence;
    }

    public void setComponentPosition(int componentPosition) {
        this.componentPosition = componentPosition;
    }

    public void incrementOffset(int value) {
        ++this.characterOffset;
        if (value == 10) {
            ++this.lineNumber;
            this.columnNumber = 0;
        }
        ++this.columnNumber;
    }

    public void incrementSegmentPosition(String segmentTag) {
        this.segmentPosition = this.segmentPosition < 0 ? 1 : ++this.segmentPosition;
        this.segmentTag = segmentTag;
        this.clearSegmentLocations();
    }

    public void clearSegmentLocations() {
        this.elementPosition = -1;
        this.elementOccurrence = -1;
        this.clearComponentPosition();
    }

    public void incrementElementPosition() {
        this.elementPosition = this.elementPosition < 0 ? 1 : ++this.elementPosition;
        this.elementOccurrence = 1;
        this.clearComponentPosition();
    }

    public void incrementElementOccurrence() {
        ++this.elementOccurrence;
        this.clearComponentPosition();
    }

    public void incrementComponentPosition() {
        this.componentPosition = this.componentPosition < 0 ? 1 : ++this.componentPosition;
    }

    public void clearComponentPosition() {
        this.componentPosition = -1;
    }

    public void setRepeated(boolean repeated) {
        this.repeated = repeated;
    }

    public boolean isRepeated() {
        return this.repeated;
    }
}

