/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.CharArraySequence;
import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.EventHandler;
import io.xlate.edi.internal.stream.tokenization.StreamEvent;
import io.xlate.edi.internal.stream.validation.UsageError;
import io.xlate.edi.internal.stream.validation.Validator;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.Location;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.List;

public class ProxyEventHandler
implements EventHandler {
    private final StaEDIStreamLocation location;
    private Schema controlSchema;
    private Validator controlValidator;
    private Schema transactionSchema;
    private Validator transactionValidator;
    private boolean transactionSchemaAllowed = false;
    private boolean transaction = false;
    private InputStream binary;
    private String segmentTag;
    private CharArraySequence elementHolder = new CharArraySequence();
    private StreamEvent[] events = new StreamEvent[99];
    private int eventCount = 0;
    private int eventIndex = 0;
    private Dialect dialect;

    public ProxyEventHandler(StaEDIStreamLocation location, Schema controlSchema) {
        this.location = location;
        this.setControlSchema(controlSchema, true);
        for (int i = 0; i < 99; ++i) {
            this.events[i] = new StreamEvent();
        }
    }

    public void setControlSchema(Schema controlSchema, boolean validateCodeValues) {
        if (this.controlValidator != null) {
            throw new IllegalStateException("control validator already created");
        }
        this.controlSchema = controlSchema;
        this.controlValidator = controlSchema != null ? new Validator(controlSchema, validateCodeValues, null) : null;
    }

    public boolean isTransactionSchemaAllowed() {
        return this.transactionSchemaAllowed;
    }

    public Schema getTransactionSchema() {
        return this.transactionSchema;
    }

    public void setTransactionSchema(Schema transactionSchema) {
        this.transactionSchema = transactionSchema;
        this.transactionValidator = transactionSchema != null ? new Validator(transactionSchema, true, this.controlSchema) : null;
    }

    public void resetEvents() {
        this.eventCount = 0;
        this.eventIndex = 0;
    }

    public EDIStreamEvent getEvent() {
        if (this.hasEvents()) {
            return this.events[this.eventIndex].type;
        }
        return null;
    }

    public CharBuffer getCharacters() {
        if (this.hasEvents()) {
            return this.events[this.eventIndex].getData();
        }
        throw new IllegalStateException();
    }

    public boolean hasEvents() {
        return this.eventIndex < this.eventCount;
    }

    public boolean nextEvent() {
        if (this.eventCount < 1) {
            return false;
        }
        return ++this.eventIndex < this.eventCount;
    }

    public EDIStreamValidationError getErrorType() {
        return this.events[this.eventIndex].errorType;
    }

    public String getReferenceCode() {
        return this.hasEvents() ? this.events[this.eventIndex].getReferenceCodeString() : null;
    }

    public Location getLocation() {
        if (this.hasEvents() && this.events[this.eventIndex].location != null) {
            return this.events[this.eventIndex].location;
        }
        return this.location;
    }

    public InputStream getBinary() {
        return this.binary;
    }

    public void setBinary(InputStream binary) {
        this.binary = binary;
    }

    @Override
    public void interchangeBegin(Dialect dialect) {
        this.dialect = dialect;
        this.enqueueEvent(EDIStreamEvent.START_INTERCHANGE, EDIStreamValidationError.NONE, "", null);
    }

    @Override
    public void interchangeEnd() {
        this.enqueueEvent(EDIStreamEvent.END_INTERCHANGE, EDIStreamValidationError.NONE, "", null);
    }

    @Override
    public void loopBegin(CharSequence id) {
        if (EDIType.Type.TRANSACTION.toString().equals(id)) {
            this.transaction = true;
            this.transactionSchemaAllowed = true;
            this.enqueueEvent(EDIStreamEvent.START_TRANSACTION, EDIStreamValidationError.NONE, id, null);
        } else if (EDIType.Type.GROUP.toString().equals(id)) {
            this.enqueueEvent(EDIStreamEvent.START_GROUP, EDIStreamValidationError.NONE, id, null);
        } else {
            this.enqueueEvent(EDIStreamEvent.START_LOOP, EDIStreamValidationError.NONE, id, id);
        }
    }

    @Override
    public void loopEnd(CharSequence id) {
        if (EDIType.Type.TRANSACTION.toString().equals(id)) {
            this.transaction = false;
            this.enqueueEvent(EDIStreamEvent.END_TRANSACTION, EDIStreamValidationError.NONE, id, null);
        } else if (EDIType.Type.GROUP.toString().equals(id)) {
            this.enqueueEvent(EDIStreamEvent.END_GROUP, EDIStreamValidationError.NONE, id, null);
        } else {
            this.enqueueEvent(EDIStreamEvent.END_LOOP, EDIStreamValidationError.NONE, id, id);
        }
    }

    @Override
    public boolean segmentBegin(String segmentTag) {
        this.segmentTag = segmentTag;
        this.transactionSchemaAllowed = false;
        Validator validator = this.validator();
        boolean eventsReady = true;
        if (validator != null && !this.dialect.isServiceAdviceSegment(segmentTag)) {
            validator.validateSegment(this, segmentTag);
            boolean bl = eventsReady = !validator.isPendingDiscrimination();
        }
        if (this.exitTransaction(segmentTag)) {
            this.transaction = false;
            this.validator().validateSegment(this, segmentTag);
        }
        this.enqueueEvent(EDIStreamEvent.START_SEGMENT, EDIStreamValidationError.NONE, segmentTag, null, this.location);
        return eventsReady;
    }

    boolean exitTransaction(CharSequence tag) {
        return this.transaction && !this.transactionSchemaAllowed && this.controlSchema != null && this.controlSchema.containsSegment(tag.toString());
    }

    @Override
    public boolean segmentEnd() {
        if (this.validator() != null) {
            this.validator().validateSyntax(this, this, this.location, false);
        }
        this.location.clearSegmentLocations();
        this.enqueueEvent(EDIStreamEvent.END_SEGMENT, EDIStreamValidationError.NONE, this.segmentTag, null, this.location);
        return true;
    }

    @Override
    public boolean compositeBegin(boolean isNil) {
        String code = null;
        boolean eventsReady = true;
        if (this.validator() != null && !isNil) {
            boolean invalid;
            boolean bl = invalid = !this.validator().validCompositeOccurrences(this.location);
            if (invalid) {
                code = this.validator().getElementReferenceCode();
                List<UsageError> errors = this.validator().getElementErrors();
                for (UsageError error : errors) {
                    this.enqueueEvent(error.getError().getCategory(), error.getError(), "", error.getCode());
                }
            } else {
                code = this.validator().getCompositeReferenceCode();
            }
            eventsReady = !this.validator().isPendingDiscrimination();
        }
        this.enqueueEvent(EDIStreamEvent.START_COMPOSITE, EDIStreamValidationError.NONE, "", code);
        return eventsReady;
    }

    @Override
    public boolean compositeEnd(boolean isNil) {
        boolean eventsReady = true;
        if (this.validator() != null && !isNil) {
            this.validator().validateSyntax(this, this, this.location, true);
            eventsReady = !this.validator().isPendingDiscrimination();
        }
        this.location.clearComponentPosition();
        this.enqueueEvent(EDIStreamEvent.END_COMPOSITE, EDIStreamValidationError.NONE, "", null);
        return eventsReady;
    }

    @Override
    public boolean elementData(char[] text, int start, int length) {
        String code;
        boolean derivedComposite;
        boolean eventsReady = true;
        this.elementHolder.set(text, start, length);
        Validator validator = this.validator();
        if (validator != null) {
            derivedComposite = this.validateElement(validator);
            code = validator.getElementReferenceCode();
        } else {
            derivedComposite = false;
            code = null;
        }
        if (!(text == null || derivedComposite && length <= 0)) {
            this.enqueueEvent(EDIStreamEvent.ELEMENT_DATA, EDIStreamValidationError.NONE, this.elementHolder, code, this.location);
            if (validator != null && validator.isPendingDiscrimination()) {
                eventsReady = validator.selectImplementation(this.events, this.eventIndex, this.eventCount, this);
            }
        }
        if (derivedComposite && text != null) {
            this.compositeEnd(length == 0);
            this.location.clearComponentPosition();
        }
        return eventsReady;
    }

    boolean validateElement(Validator validator) {
        List<UsageError> errors;
        boolean derivedComposite;
        boolean composite = this.location.getComponentPosition() > -1;
        boolean valid = validator.validateElement(this.dialect, this.location, this.elementHolder);
        boolean bl = derivedComposite = !composite && validator.isComposite();
        if (!valid) {
            errors = validator.getElementErrors();
            Iterator<UsageError> cursor = errors.iterator();
            while (cursor.hasNext()) {
                UsageError error = cursor.next();
                switch (error.getError()) {
                    case TOO_MANY_DATA_ELEMENTS: 
                    case TOO_MANY_REPETITIONS: {
                        this.enqueueEvent(error.getError().getCategory(), error.getError(), this.elementHolder, error.getCode(), this.location);
                        cursor.remove();
                    }
                }
            }
        }
        if (derivedComposite && this.elementHolder.getText() != null) {
            this.compositeBegin(this.elementHolder.length() == 0);
            this.location.incrementComponentPosition();
        }
        if (!valid) {
            errors = validator.getElementErrors();
            for (UsageError error : errors) {
                this.enqueueEvent(error.getError().getCategory(), error.getError(), this.elementHolder, error.getCode(), this.location);
            }
        }
        return derivedComposite;
    }

    public boolean isBinaryElementLength() {
        return this.validator() != null && this.validator().isBinaryElementLength();
    }

    @Override
    public boolean binaryData(InputStream binaryStream) {
        this.enqueueEvent(EDIStreamEvent.ELEMENT_DATA_BINARY, EDIStreamValidationError.NONE, "", null);
        this.setBinary(binaryStream);
        return true;
    }

    @Override
    public void segmentError(CharSequence token, EDIStreamValidationError error) {
        this.enqueueEvent(EDIStreamEvent.SEGMENT_ERROR, error, token, token);
    }

    @Override
    public void elementError(EDIStreamEvent event, EDIStreamValidationError error, CharSequence referenceCode, int element, int component, int repetition) {
        StaEDIStreamLocation copy = this.location.copy();
        copy.setElementPosition(element);
        copy.setElementOccurrence(repetition);
        copy.setComponentPosition(component);
        this.enqueueEvent(event, error, null, referenceCode, copy);
    }

    private Validator validator() {
        return this.transaction && !this.transactionSchemaAllowed ? this.transactionValidator : this.controlValidator;
    }

    private void enqueueEvent(EDIStreamEvent event, EDIStreamValidationError error, CharSequence holder, CharSequence code, Location location) {
        this.enqueueEvent(this.eventCount, event, error, holder, code, location);
        ++this.eventCount;
    }

    private void enqueueEvent(EDIStreamEvent event, EDIStreamValidationError error, CharSequence text, CharSequence code) {
        this.enqueueEvent(this.eventCount, event, error, text, code, this.location);
        ++this.eventCount;
    }

    private void enqueueEvent(int index, EDIStreamEvent event, EDIStreamValidationError error, CharSequence data, CharSequence code, Location location) {
        EDIStreamEvent associatedEvent;
        StreamEvent target = this.events[index];
        EDIStreamEvent eDIStreamEvent = associatedEvent = index > 0 ? ProxyEventHandler.getAssociatedEvent(error) : null;
        if (associatedEvent != null) {
            int offset = index;
            boolean complete = false;
            while (!complete && offset > 0) {
                if (this.events[offset - 1].type == associatedEvent) {
                    complete = true;
                    continue;
                }
                this.events[offset] = this.events[offset - 1];
                --offset;
            }
            this.events[offset] = target;
        }
        target.type = event;
        target.errorType = error;
        target.setData(data);
        target.setReferenceCode(code);
        target.setLocation(location);
    }

    private static EDIStreamEvent getAssociatedEvent(EDIStreamValidationError error) {
        EDIStreamEvent event;
        switch (error) {
            case IMPLEMENTATION_LOOP_OCCURS_UNDER_MINIMUM_TIMES: {
                event = EDIStreamEvent.END_LOOP;
                break;
            }
            case MANDATORY_SEGMENT_MISSING: 
            case IMPLEMENTATION_SEGMENT_BELOW_MINIMUM_USE: {
                event = null;
                break;
            }
            default: {
                event = null;
            }
        }
        return event;
    }
}

