/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.ValidationEventHandler;
import io.xlate.edi.internal.stream.validation.ConditionSyntaxValidator;
import io.xlate.edi.internal.stream.validation.ExclusionSyntaxValidator;
import io.xlate.edi.internal.stream.validation.ListSyntaxValidator;
import io.xlate.edi.internal.stream.validation.PairedSyntaxValidator;
import io.xlate.edi.internal.stream.validation.RequiredSyntaxValidator;
import io.xlate.edi.internal.stream.validation.SingleSyntaxValidator;
import io.xlate.edi.internal.stream.validation.UsageNode;
import io.xlate.edi.schema.EDISyntaxRule;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

interface SyntaxValidator {
    public static SyntaxValidator getInstance(EDISyntaxRule.Type type) {
        switch (type) {
            case CONDITIONAL: {
                return ConditionSyntaxValidator.getInstance();
            }
            case EXCLUSION: {
                return ExclusionSyntaxValidator.getInstance();
            }
            case LIST: {
                return ListSyntaxValidator.getInstance();
            }
            case PAIRED: {
                return PairedSyntaxValidator.getInstance();
            }
            case REQUIRED: {
                return RequiredSyntaxValidator.getInstance();
            }
            case SINGLE: {
                return SingleSyntaxValidator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unexpected syntax restriction type " + (Object)((Object)type) + ".");
    }

    default public SyntaxStatus scanSyntax(EDISyntaxRule syntax, List<UsageNode> children) {
        SyntaxStatus status = new SyntaxStatus();
        AtomicBoolean anchorPosition = new AtomicBoolean(true);
        syntax.getPositions().stream().filter(position -> position < children.size() + 1).map(position -> (UsageNode)children.get(position - 1)).forEach(node -> {
            if (node.isUsed()) {
                ++status.elementCount;
                if (anchorPosition.get()) {
                    status.anchorPresent = true;
                }
            }
            anchorPosition.set(false);
        });
        return status;
    }

    default public void signalConditionError(EDISyntaxRule syntax, UsageNode structure, ValidationEventHandler handler) {
        List<UsageNode> children = structure.getChildren();
        int limit = children.size() + 1;
        for (int position : syntax.getPositions()) {
            String referenceCode;
            boolean used;
            if (position < limit) {
                UsageNode node = children.get(position - 1);
                used = node.isUsed();
                referenceCode = node.getCode();
            } else {
                used = false;
                referenceCode = null;
            }
            if (used) continue;
            int element = SyntaxValidator.getElementPosition(structure, position);
            int component = SyntaxValidator.getComponentPosition(structure, position);
            handler.elementError(EDIStreamEvent.ELEMENT_OCCURRENCE_ERROR, EDIStreamValidationError.CONDITIONAL_REQUIRED_DATA_ELEMENT_MISSING, referenceCode, element, component, -1);
        }
    }

    default public void signalExclusionError(EDISyntaxRule syntax, UsageNode structure, ValidationEventHandler handler) {
        List<UsageNode> children = structure.getChildren();
        int limit = children.size() + 1;
        int tally = 0;
        for (int position : syntax.getPositions()) {
            if (position >= limit || !children.get(position - 1).isUsed() || ++tally <= 1) continue;
            int element = SyntaxValidator.getElementPosition(structure, position);
            int component = SyntaxValidator.getComponentPosition(structure, position);
            handler.elementError(EDIStreamEvent.ELEMENT_OCCURRENCE_ERROR, EDIStreamValidationError.EXCLUSION_CONDITION_VIOLATED, structure.getCode(), element, component, -1);
        }
    }

    public static int getComponentPosition(UsageNode structure, int position) {
        return structure.isNodeType(EDIType.Type.COMPOSITE) ? position : -1;
    }

    public static int getElementPosition(UsageNode structure, int position) {
        if (structure.isNodeType(EDIType.Type.COMPOSITE)) {
            return structure.getParent().getIndex() + 1;
        }
        return position;
    }

    public void validate(EDISyntaxRule var1, UsageNode var2, ValidationEventHandler var3);

    public static class SyntaxStatus {
        protected int elementCount = 0;
        protected boolean anchorPresent = false;
    }
}

