/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.plugin.mojos.base;

import io.yawp.plugin.mojos.base.PluginAbstractMojo;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;

public class ClassLoaderBuilder {
    private List<URL> urls = new ArrayList<URL>();

    public URLClassLoader build(boolean isolated) {
        if (isolated) {
            return new URLClassLoader(this.urls.toArray(new URL[0]));
        }
        return new URLClassLoader(this.urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    public void addRuntime(PluginAbstractMojo mojo) {
        try {
            if (mojo.getProject() == null) {
                return;
            }
            this.add(mojo.getProject().getTestClasspathElements());
            this.add(mojo.getProject().getRuntimeClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(List<String> classpathElements) {
        List<String> elements = classpathElements;
        for (int i = 0; i < elements.size(); ++i) {
            String element = elements.get(i);
            this.add(element);
        }
    }

    public void add(String element) {
        try {
            this.urls.add(new File(element).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

