/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.plugin.mojos.devserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.yawp.commons.utils.JsonUtils;
import io.yawp.plugin.devserver.MojoWrapper;
import io.yawp.plugin.mojos.base.ClassLoaderBuilder;
import io.yawp.plugin.mojos.devserver.DevserverAbstractMojo;
import io.yawp.plugin.mojos.devserver.SdkResolver;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Execute(phase=LifecyclePhase.COMPILE)
@Mojo(name="devserver", requiresDependencyResolution=ResolutionScope.TEST)
public class DevServerMojo
extends DevserverAbstractMojo {
    private static final String YAWP_GROUP_ID = "io.yawp";
    private static final String YAWP_ARTIFACT_ID = "yawp";
    private static final String YAWP_DEVSERVER_ARTIFACT_ID = "yawp-devserver-runtime";
    @Parameter(property="yawp.address", defaultValue="0.0.0.0")
    private String address;
    @Parameter(property="yawp.port", defaultValue="8080")
    private String port;
    @Parameter(property="yawp.fullScanSeconds", defaultValue="3")
    private String fullScanSeconds;
    @Parameter(property="yawp.hotDeployDir", defaultValue="${basedir}/target/classes")
    protected String hotDeployDir;

    @Override
    public void run() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Starting webserver at: " + this.getAppDir()));
        this.runDevServer();
    }

    private void runDevServer() {
        URLClassLoader classLoader = this.createDevServerClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Class<?> clazz = classLoader.loadClass("io.yawp.plugin.devserver.DevServer");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            Object devserver = constructor.newInstance(this.createMojoWrapperJson());
            Method run = clazz.getMethod("run", new Class[0]);
            run.invoke(devserver, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private String createMojoWrapperJson() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        MojoWrapper mojo = new MojoWrapper();
        mojo.setEnv(this.getEnv());
        mojo.setBaseDir(this.getBaseDir());
        mojo.setAppDir(this.getAppDir());
        mojo.setAddress(this.getAddress());
        mojo.setPort(Integer.valueOf(this.getPort()));
        mojo.setFullScanSeconds(Integer.valueOf(this.getFullScanSeconds()));
        mojo.setHotDeployDir(this.getHotDeployDir());
        mojo.setShutdownPort(Integer.valueOf(this.getShutdownPort()));
        mojo.setAppengine(this.isAppengine());
        return JsonUtils.to((Object)mojo);
    }

    private void set(Object mojo, String setter, Object value) {
        try {
            if (value == null) {
                return;
            }
            Method method = mojo.getClass().getMethod(setter, value.getClass());
            method.invoke(mojo, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String getHotDeployDir() {
        return this.hotDeployDir;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return Integer.valueOf(this.port);
    }

    public int getFullScanSeconds() {
        return Integer.valueOf(this.fullScanSeconds);
    }

    protected URLClassLoader createDevServerClassLoader() {
        ClassLoaderBuilder builder = new ClassLoaderBuilder();
        builder.addRuntime(this);
        builder.add(this.resolveDevServerJar());
        if (this.isAppengine()) {
            builder.add(this.getAppengineCustomClasspathElements());
        }
        return builder.build(true);
    }

    public List<String> getAppengineCustomClasspathElements() {
        String sdkRoot = this.resolveSdkRoot();
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(sdkRoot + "/lib/shared/el-api.jar");
        elements.add(sdkRoot + "/lib/shared/jsp-api.jar");
        elements.add(sdkRoot + "/lib/impl/appengine-local-runtime.jar");
        elements.add(sdkRoot + "/lib/shared/appengine-local-runtime-shared.jar");
        elements.add(sdkRoot + "/lib/java-managed-vm/appengine-java-vmruntime/lib/ext/appengine-vm-runtime.jar");
        return elements;
    }

    protected boolean isAppengine() {
        if (this.project.getGroupId().equals(YAWP_GROUP_ID) && this.project.getArtifactId().equals(YAWP_ARTIFACT_ID)) {
            return true;
        }
        for (Dependency dependency : this.project.getDependencies()) {
            if (!dependency.getGroupId().equals(YAWP_GROUP_ID) || !dependency.getArtifactId().equals(YAWP_ARTIFACT_ID)) continue;
            return true;
        }
        return false;
    }

    public String resolveDevServerJar() {
        ArtifactResult result;
        String version = this.getYawpVersion();
        ImmutableList allRepos = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable[])new Iterable[]{this.getProjectRepos()}));
        ArtifactRequest request = new ArtifactRequest((Artifact)new DefaultArtifact(YAWP_GROUP_ID, YAWP_DEVSERVER_ARTIFACT_ID, "jar", version), (List)allRepos, null);
        try {
            result = this.repoSystem.resolveArtifact(this.repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException("Could not resolve DevServer artifact in Maven.");
        }
        return result.getArtifact().getFile().getPath();
    }

    private String resolveSdkRoot() {
        try {
            File sdkBaseDir = SdkResolver.getSdk(this.getProject(), this.getRepoSystem(), this.getRepoSession(), this.getPluginRepos(), this.getProjectRepos());
            System.setProperty("appengine.sdk.root", sdkBaseDir.getCanonicalPath());
            return sdkBaseDir.getAbsolutePath();
        }
        catch (IOException | MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getYawpVersion() {
        for (Dependency dependency : this.project.getDependencies()) {
            if (!dependency.getGroupId().equals(YAWP_GROUP_ID)) continue;
            return dependency.getVersion();
        }
        throw new RuntimeException("Could not resolve YAWP! version in Maven.");
    }
}

