/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.plugin.mojos.devserver;

import io.yawp.plugin.mojos.devserver.DevserverAbstractMojo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="devserver_wait")
public class DevServerWaitMojo
extends DevserverAbstractMojo {
    private static final int SLEEP_MILLIS = 500;
    private static final int MAX_RETRIES = 120;

    @Override
    public void run() throws MojoExecutionException {
        this.waitSever();
    }

    private void waitSever() {
        int retries;
        for (retries = 0; retries < 120; ++retries) {
            try {
                this.tryToConnect();
                break;
            }
            catch (IOException e) {
                this.sleep();
                continue;
            }
        }
        if (retries == 120) {
            throw new RuntimeException(String.format("Reached max retries", new Object[0]));
        }
    }

    private void sleep() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void tryToConnect() throws IOException, UnknownHostException {
        Socket socket = new Socket(InetAddress.getByName("127.0.0.1"), this.getShutdownPort());
        socket.close();
    }
}

