/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.plugin.mojos.devserver;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

public class SdkResolver {
    private static final String SDK_GROUP_ID = "com.google.appengine";
    private static final String SDK_ARTIFACT_ID = "appengine-java-sdk";
    private static final String SDK_EXTENSION = "zip";

    private SdkResolver() {
    }

    public static File getSdk(MavenProject project, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> ... repos) throws MojoExecutionException {
        org.apache.maven.artifact.Artifact artifact = (org.apache.maven.artifact.Artifact)Iterables.find((Iterable)project.getPluginArtifacts(), (Predicate)new Predicate<org.apache.maven.artifact.Artifact>(){

            public boolean apply(org.apache.maven.artifact.Artifact artifact1) {
                return artifact1.getArtifactId().equals("appengine-maven-plugin");
            }
        });
        String version = artifact.getVersion();
        if (version.endsWith("-SNAPSHOT")) {
            String newestVersion = SdkResolver.determineNewestVersion(repoSystem, repoSession, repos);
            return SdkResolver.getSdk(newestVersion, repoSystem, repoSession, repos);
        }
        return SdkResolver.getSdk(version, repoSystem, repoSession, repos);
    }

    private static String determineNewestVersion(RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository>[] repos) throws MojoExecutionException {
        VersionRangeResult rangeResult;
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)new DefaultArtifact("com.google.appengine:appengine-java-sdk:[0,)"));
        for (List<RemoteRepository> repoList : repos) {
            for (RemoteRepository repo : repoList) {
                rangeRequest.addRepository(repo);
            }
        }
        try {
            rangeResult = repoSystem.resolveVersionRange(repoSession, rangeRequest);
        }
        catch (VersionRangeResolutionException e) {
            throw new MojoExecutionException("Could not resolve latest version of the App Engine Java SDK", (Exception)((Object)e));
        }
        List versions = rangeResult.getVersions();
        Collections.sort(versions);
        Version newest = (Version)Iterables.getLast((Iterable)versions);
        String version = newest.toString();
        return version;
    }

    public static File getSdk(String version, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> ... repos) throws MojoExecutionException {
        ArtifactResult result;
        ImmutableList allRepos = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable[])repos));
        ArtifactRequest request = new ArtifactRequest((Artifact)new DefaultArtifact(SDK_GROUP_ID, SDK_ARTIFACT_ID, SDK_EXTENSION, version), (List)allRepos, null);
        try {
            result = repoSystem.resolveArtifact(repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Could not resolve SDK artifact in Maven.", (Exception)((Object)e));
        }
        File sdkArchive = result.getArtifact().getFile();
        File sdkRepoDir = sdkArchive.getParentFile();
        File sdkBaseDir = new File(sdkRepoDir, SDK_ARTIFACT_ID);
        if (sdkBaseDir.exists() && !sdkBaseDir.isDirectory()) {
            throw new MojoExecutionException("Could not unpack the SDK because there is an unexpected file at " + sdkBaseDir + " which conflicts with where we plan to unpack the SDK.");
        }
        if (!sdkBaseDir.exists()) {
            sdkBaseDir.mkdirs();
        }
        String sdkBaseDirSuffix = null;
        try {
            ZipFile sdkZipArchive = new ZipFile(sdkArchive);
            Enumeration<? extends ZipEntry> zipEntries = sdkZipArchive.entries();
            if (!zipEntries.hasMoreElements()) {
                throw new MojoExecutionException("The SDK zip archive appears corrupted.  There are no entries in the zip index.");
            }
            ZipEntry firstEntry = zipEntries.nextElement();
            if (firstEntry.isDirectory()) {
                sdkBaseDirSuffix = firstEntry.getName();
            } else {
                zipEntries = sdkZipArchive.entries();
            }
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (zipEntry.isDirectory()) continue;
                File zipEntryDestination = new File(sdkBaseDir, zipEntry.getName());
                if (!zipEntry.getName().startsWith(sdkBaseDirSuffix)) {
                    sdkBaseDirSuffix = null;
                }
                if (zipEntryDestination.exists()) continue;
                Files.createParentDirs((File)zipEntryDestination);
                Files.write((byte[])ByteStreams.toByteArray((InputStream)sdkZipArchive.getInputStream(zipEntry)), (File)zipEntryDestination);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not open SDK zip archive.", (Exception)e);
        }
        if (sdkBaseDirSuffix == null) {
            return sdkBaseDir;
        }
        return new File(sdkBaseDir, sdkBaseDirSuffix);
    }
}

