/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.plugin.mojos.scaffolding;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.WordUtils;
import org.atteo.evo.inflector.English;

public class EndpointNaming {
    private Properties customPlurals;
    private String input;
    private String action;
    private String transformer;
    private String hook;
    private String pipe;
    private String pipeSink;

    public EndpointNaming(String input) {
        this.loadCustomPlurals();
        this.input = input;
    }

    private void loadCustomPlurals() {
        try {
            this.customPlurals = new Properties();
            InputStream in = this.getClass().getResourceAsStream("/custom_plurals.properties");
            this.customPlurals.load(in);
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String plural(String word) {
        String key = word.toLowerCase();
        if (this.customPlurals.containsKey(key)) {
            return this.customPlurals.getProperty(key);
        }
        return English.plural((String)word);
    }

    private String capitalize(String word) {
        return WordUtils.capitalize((String)word, (char[])new char[]{'_'}).replaceAll("_", "");
    }

    public EndpointNaming action(String action) {
        this.action = action;
        return this;
    }

    public EndpointNaming transformer(String transformer) {
        this.transformer = transformer;
        return this;
    }

    public EndpointNaming hook(String hook) {
        this.hook = hook;
        return this;
    }

    public EndpointNaming pipe(String pipe) {
        this.pipe = pipe;
        return this;
    }

    public EndpointNaming pipeSink(String sink) {
        this.pipeSink = sink;
        return this;
    }

    public String getName() {
        return this.capitalize(this.input);
    }

    public String getPackageName() {
        return this.getName().toLowerCase();
    }

    public String getPath() {
        String endpointPath = this.getName().replaceAll("(.)(\\p{Lu})", "$1-$2").toLowerCase();
        return this.plural(endpointPath);
    }

    public String getFilename() {
        return String.format("%s/%s.java", this.getPackageName(), this.getName());
    }

    public String getTestName() {
        return String.format("%sTest", this.getName());
    }

    public String getTestFilename() {
        return String.format("%s/%s.java", this.getPackageName(), this.getTestName());
    }

    public String getInstance() {
        return WordUtils.uncapitalize((String)this.getName());
    }

    public String getShieldName() {
        return String.format("%sShield", this.getName());
    }

    public String getShieldFilename() {
        return String.format("%s/%s.java", this.getPackageName(), this.getShieldName());
    }

    public String getActionName() {
        return String.format("%s%sAction", this.getName(), this.capitalize(this.action));
    }

    public String getActionFilename() {
        return String.format("%s/%s.java", this.getPackageName(), this.getActionName());
    }

    public String getTransformerName() {
        return String.format("%s%sTransformer", this.getName(), this.capitalize(this.transformer));
    }

    public String getTransformerFilename() {
        return String.format("%s/%s.java", this.getPackageName(), this.getTransformerName());
    }

    public String getHookName() {
        return String.format("%s%sHook", this.getName(), this.capitalize(this.hook));
    }

    public String getHookFilename() {
        return String.format("%s/%s.java", this.getPackageName(), this.getHookName());
    }

    public String getPipeName() {
        return String.format("%s%sPipe", this.getName(), this.capitalize(this.pipe));
    }

    public String getPipeSinkName() {
        return this.capitalize(this.pipeSink);
    }

    public String getPipeSinkInstance() {
        return WordUtils.uncapitalize((String)this.getPipeSinkName());
    }

    public String getPipeFilename() {
        return String.format("%s/%s.java", this.getPackageName(), this.getPipeName());
    }
}

