/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.plugin.mojos.scaffolding;

import io.yawp.plugin.mojos.scaffolding.EndpointNaming;
import io.yawp.plugin.mojos.scaffolding.ScaffoldAlreadyExistsException;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.plugin.logging.Log;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public abstract class Scaffolder {
    private static final String SOURCE_MAIN_JAVA = "src/main/java";
    private static final String SOURCE_TEST_JAVA = "src/test/java";
    private static final String MODELS_FOLDER = "models";
    private Log log;
    protected EndpointNaming endpointNaming;
    protected String yawpPackage;

    public Scaffolder(Log log, String yawpPackage, String model) {
        this.log = log;
        this.yawpPackage = yawpPackage;
        this.endpointNaming = new EndpointNaming(model);
    }

    public void createTo(String baseDir) {
        this.log.info((CharSequence)("Scaffolding to " + baseDir));
        this.execute(baseDir);
    }

    protected abstract void execute(String var1);

    private String parse(String scaffoldingTemplate) {
        VelocityContext context = new VelocityContext();
        context.put("yawpPackage", (Object)this.yawpPackage);
        context.put("endpoint", (Object)this.endpointNaming);
        return this.parseTemplate(scaffoldingTemplate, context);
    }

    private String parseTemplate(String scaffoldingTemplate, VelocityContext context) {
        VelocityEngine engine = this.createVelocityEngine();
        Template template = engine.getTemplate(scaffoldingTemplate);
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    private VelocityEngine createVelocityEngine() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        return ve;
    }

    private File getFile(String baseDir, String relativeFilename) throws ScaffoldAlreadyExistsException {
        String filename = String.format("%s/%s", baseDir, relativeFilename);
        File file = new File(filename);
        if (file.exists()) {
            throw new ScaffoldAlreadyExistsException();
        }
        file.getParentFile().mkdirs();
        return file;
    }

    private String yawpPackageDir() {
        return this.yawpPackage.replaceAll("\\.", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(String baseDir, String relativeFilename, String content) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new FileWriter(this.getFile(baseDir, relativeFilename)));
            pw.print(content);
            this.log.info((CharSequence)String.format("Scaffold %s created.", relativeFilename));
        }
    }

    private String sourceMainJava() {
        return String.format("%s/%s/%s", SOURCE_MAIN_JAVA, this.yawpPackageDir(), MODELS_FOLDER);
    }

    private String sourceTestJava() {
        return String.format("%s/%s/%s", SOURCE_TEST_JAVA, this.yawpPackageDir(), MODELS_FOLDER);
    }

    protected void sourceMainJava(String baseDir, String filename, String modelTemplate) {
        String relativeFilename = String.format("%s/%s", this.sourceMainJava(), filename);
        this.createFile(baseDir, relativeFilename, this.parse(modelTemplate));
    }

    protected void sourceTestJava(String baseDir, String filename, String modelTemplate) {
        String relativeFilename = String.format("%s/%s", this.sourceTestJava(), filename);
        this.createFile(baseDir, relativeFilename, this.parse(modelTemplate));
    }
}

