/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql;

import io.yawp.commons.utils.NameGenerator;
import io.yawp.commons.utils.kind.KindResolver;
import io.yawp.driver.postgresql.datastore.Key;
import io.yawp.driver.postgresql.datastore.KeyFactory;
import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.models.ObjectModel;

public class IdRefToKey {
    public static Key toKey(Repository r, IdRef<?> id) {
        return IdRefToKey.convertWithinRightNamespace(r, id.getClazz(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key convertWithinRightNamespace(Repository r, Class<?> clazz, IdRef<?> id) {
        r.namespace().set(clazz);
        try {
            Key parent = id.getParentId() == null ? null : IdRefToKey.toKey(r, id.getParentId());
            String kind = KindResolver.getKindFromClass((Class)id.getClazz());
            Key key = IdRefToKey.createKey(id, parent, kind);
            return key;
        }
        finally {
            r.namespace().reset();
        }
    }

    public static IdRef<?> toIdRef(Repository r, Key key, ObjectModel model) {
        Class objectClass = model.getClazz();
        IdRef idRef = null;
        idRef = model.isIdShuffled() ? IdRefToKey.getIdRefFromShuffledKey(r, key, objectClass) : (key.getName() != null ? IdRef.create((Repository)r, (Class)objectClass, (String)key.getName()) : IdRef.create((Repository)r, (Class)objectClass, (Long)key.getId()));
        if (key.getParent() != null) {
            idRef.setParentId(IdRefToKey.toIdRef(r, key.getParent(), IdRefToKey.createParentModel(r, key)));
        }
        return idRef;
    }

    private static Key createKey(IdRef<?> id, Key parent, String kind) {
        if (id.isShuffled()) {
            return IdRefToKey.createShuffledKey(id, parent, kind);
        }
        if (id.getId() == null) {
            return KeyFactory.createKey(parent, kind, id.getName());
        }
        return KeyFactory.createKey(parent, kind, id.getId());
    }

    private static Key createShuffledKey(IdRef<?> id, Key parent, String kind) {
        if (id.getId() == null) {
            return KeyFactory.createKey(parent, kind, NameGenerator.generateFromString((String)id.getName()));
        }
        return KeyFactory.createKey(parent, kind, NameGenerator.generateFromString((String)(id.getId() + "")));
    }

    private static IdRef<?> getIdRefFromShuffledKey(Repository r, Key key, Class<?> objectClass) {
        IdRef idRef;
        String name = NameGenerator.convertToString((String)key.getName());
        try {
            Long id = Long.valueOf(name);
            idRef = IdRef.create((Repository)r, objectClass, (Long)id);
        }
        catch (NumberFormatException e) {
            idRef = IdRef.create((Repository)r, objectClass, (String)name);
        }
        return idRef;
    }

    private static ObjectModel createParentModel(Repository r, Key key) {
        String parentKind = key.getParent().getKind();
        Class parentClazz = r.getClazzByKind(parentKind);
        return new ObjectModel(parentClazz);
    }
}

