/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql;

import io.yawp.commons.utils.Environment;
import io.yawp.driver.api.HelpersDriver;
import io.yawp.driver.postgresql.configuration.InitialContextSetup;
import io.yawp.driver.postgresql.configuration.WebConfiguration;
import io.yawp.driver.postgresql.tools.DatabaseSynchronizer;
import io.yawp.repository.Yawp;
import java.io.File;
import java.util.Set;

public class PGHelpersDriver
implements HelpersDriver {
    private DatabaseSynchronizer dbSynchronizer = new DatabaseSynchronizer();

    public void deleteAll() {
        this.dbSynchronizer.truncateAll();
    }

    public void sync() {
        InitialContextSetup.configure(this.getJettyConfigFile());
        this.dbSynchronizer.sync(this.scanEndpointClazzes());
    }

    private Set<Class<?>> scanEndpointClazzes() {
        WebConfiguration webConfiguration = new WebConfiguration(this.getWebConfigFile());
        if (webConfiguration.getPackagePrefix() != null) {
            Yawp.init((String)webConfiguration.getPackagePrefix());
        }
        return Yawp.yawp.getFeatures().getEndpointClazzes();
    }

    private File getJettyConfigFile() {
        return new File(String.format("%s/WEB-INF/jetty-env.xml", Environment.getAppDir()));
    }

    private String getWebConfigFile() {
        return String.format("%s/WEB-INF/web.xml", Environment.getAppDir());
    }
}

