/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql;

import io.yawp.commons.utils.JsonUtils;
import io.yawp.driver.api.PersistenceDriver;
import io.yawp.driver.postgresql.IdRefToKey;
import io.yawp.driver.postgresql.datastore.Datastore;
import io.yawp.driver.postgresql.datastore.Entity;
import io.yawp.driver.postgresql.datastore.Key;
import io.yawp.driver.postgresql.sql.ConnectionManager;
import io.yawp.repository.FutureObject;
import io.yawp.repository.IdRef;
import io.yawp.repository.LazyJson;
import io.yawp.repository.Repository;
import io.yawp.repository.models.FieldModel;
import io.yawp.repository.models.ObjectHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;

public class PGPersistenceDriver
implements PersistenceDriver {
    private Repository r;
    private Datastore datastore;

    public PGPersistenceDriver(Repository r, ConnectionManager connectionManager) {
        this.r = r;
        this.datastore = Datastore.create(connectionManager);
    }

    public void save(Object object) {
        ObjectHolder objectHolder = new ObjectHolder(object);
        Entity entity = this.createEntity(objectHolder);
        this.toEntity(objectHolder, entity);
        this.saveEntity(objectHolder, entity);
    }

    public <T> FutureObject<T> saveAsync(Object object) {
        ObjectHolder objectHolder = new ObjectHolder(object);
        Entity entity = this.createEntity(objectHolder);
        this.toEntity(objectHolder, entity);
        return this.saveEntityAsync(objectHolder, entity);
    }

    public void destroy(IdRef<?> id) {
        this.datastore.delete(IdRefToKey.toKey(this.r, id));
    }

    private Entity createEntity(ObjectHolder objectHolder) {
        IdRef id = objectHolder.getId();
        if (id == null) {
            return this.createEntityWithNewKey(objectHolder);
        }
        return new Entity(IdRefToKey.toKey(this.r, id));
    }

    private Entity createEntityWithNewKey(ObjectHolder objectHolder) {
        IdRef parentId = objectHolder.getParentId();
        if (parentId == null) {
            return new Entity(objectHolder.getModel().getKind());
        }
        return new Entity(objectHolder.getModel().getKind(), IdRefToKey.toKey(this.r, parentId));
    }

    private void saveEntity(ObjectHolder objectHolder, Entity entity) {
        Key key = this.datastore.put(entity);
        objectHolder.setId(IdRefToKey.toIdRef(this.r, key, objectHolder.getModel()));
    }

    private <T> FutureObject<T> saveEntityAsync(ObjectHolder objectHolder, Entity entity) {
        Key key = this.datastore.put(entity);
        Future futureId = ConcurrentUtils.constantFuture(IdRefToKey.toIdRef(this.r, key, objectHolder.getModel()));
        return new FutureObject(this.r, futureId, objectHolder.getObject());
    }

    public void toEntity(ObjectHolder objectHolder, Entity entity) {
        List fieldModels = objectHolder.getModel().getFieldModels();
        for (FieldModel fieldModel : fieldModels) {
            if (fieldModel.isId() || fieldModel.isTransient()) continue;
            this.setEntityProperty(objectHolder, entity, fieldModel);
        }
    }

    private void setEntityProperty(ObjectHolder objectHolder, Entity entity, FieldModel fieldModel) {
        Object value = this.getFieldValue(fieldModel, objectHolder);
        if (!fieldModel.hasIndex()) {
            entity.setUnindexedProperty(fieldModel.getName(), value);
            return;
        }
        if (fieldModel.isIndexNormalizable()) {
            entity.setProperty("__" + fieldModel.getName(), this.normalizeValue(value));
            entity.setUnindexedProperty(fieldModel.getName(), value);
            return;
        }
        entity.setProperty(fieldModel.getName(), value);
    }

    private Object getFieldValue(FieldModel fieldModel, ObjectHolder objectHolder) {
        Object value = fieldModel.getValue(objectHolder.getObject());
        if (value == null) {
            return null;
        }
        if (fieldModel.isEnum(value)) {
            return value.toString();
        }
        if (fieldModel.isSaveAsJson()) {
            return JsonUtils.to((Object)value);
        }
        if (fieldModel.isSaveAsLazyJson()) {
            String json = ((LazyJson)value).getJson();
            if (json == null) {
                return null;
            }
            return json;
        }
        if (fieldModel.isIdRef()) {
            IdRef idRef = (IdRef)value;
            return idRef.getUri();
        }
        if (fieldModel.isSaveAsText()) {
            return value.toString();
        }
        if (fieldModel.isListOfIds()) {
            return this.convertToListOfUris((List)value);
        }
        return value;
    }

    private List<String> convertToListOfUris(List<IdRef<?>> ids) {
        ArrayList<String> uris = new ArrayList<String>(ids.size());
        for (IdRef<?> id : ids) {
            uris.add(id.getUri());
        }
        return uris;
    }

    private Object normalizeValue(Object o) {
        if (o == null) {
            return null;
        }
        if (!o.getClass().equals(String.class)) {
            return o;
        }
        return StringUtils.stripAccents((String)((String)o)).toLowerCase();
    }
}

