/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql;

import io.yawp.commons.http.HttpVerb;
import io.yawp.commons.utils.DateUtils;
import io.yawp.commons.utils.JsonUtils;
import io.yawp.commons.utils.ReflectionUtils;
import io.yawp.driver.api.QueryDriver;
import io.yawp.driver.postgresql.IdRefToKey;
import io.yawp.driver.postgresql.datastore.Datastore;
import io.yawp.driver.postgresql.datastore.Entity;
import io.yawp.driver.postgresql.datastore.EntityNotFoundException;
import io.yawp.driver.postgresql.datastore.FalsePredicateException;
import io.yawp.driver.postgresql.datastore.Key;
import io.yawp.driver.postgresql.datastore.Query;
import io.yawp.driver.postgresql.sql.ConnectionManager;
import io.yawp.repository.IdRef;
import io.yawp.repository.LazyJson;
import io.yawp.repository.Repository;
import io.yawp.repository.models.FieldModel;
import io.yawp.repository.models.ObjectHolder;
import io.yawp.repository.models.ObjectModel;
import io.yawp.repository.query.QueryBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PGQueryDriver
implements QueryDriver {
    private Repository r;
    private Datastore datastore;

    public PGQueryDriver(Repository r, ConnectionManager connectionManager) {
        this.r = r;
        this.datastore = Datastore.create(connectionManager);
    }

    public <T> List<T> objects(QueryBuilder<?> builder) {
        try {
            List<Entity> queryResult = this.generateResults(builder, false);
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Entity entity : queryResult) {
                objects.add(this.toObject(builder.getModel(), entity));
            }
            return objects;
        }
        catch (FalsePredicateException e) {
            return Collections.emptyList();
        }
    }

    public <T> List<IdRef<T>> ids(QueryBuilder<?> builder) {
        try {
            List<Entity> queryResult = this.generateResults(builder, false);
            ArrayList<IdRef<T>> ids = new ArrayList<IdRef<T>>();
            for (Entity entity : queryResult) {
                ids.add(IdRefToKey.toIdRef(this.r, entity.getKey(), builder.getModel()));
            }
            return ids;
        }
        catch (FalsePredicateException e) {
            return Collections.emptyList();
        }
    }

    public <T> T fetch(IdRef<T> id) {
        try {
            Key key = IdRefToKey.toKey(this.r, id);
            Entity entity = this.datastore.get(key);
            return (T)this.toObject(id.getModel(), entity);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    private List<Entity> generateResults(QueryBuilder<?> builder, boolean keysOnly) throws FalsePredicateException {
        return this.datastore.query(new Query(builder, keysOnly));
    }

    public Object toObject(ObjectModel model, Entity entity) {
        Object object = model.createInstance();
        ObjectHolder objectHolder = new ObjectHolder(object);
        objectHolder.setId(IdRefToKey.toIdRef(this.r, entity.getKey(), model));
        List fieldModels = objectHolder.getModel().getFieldModels();
        for (FieldModel fieldModel : fieldModels) {
            if (fieldModel.isId() || fieldModel.isTransient()) continue;
            this.safeSetObjectProperty(entity, object, fieldModel);
        }
        return object;
    }

    private <T> void safeSetObjectProperty(Entity entity, T object, FieldModel fieldModel) {
        try {
            this.setObjectProperty(object, entity, fieldModel, fieldModel.getField());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void setObjectProperty(T object, Entity entity, FieldModel fieldModel, Field field) throws IllegalAccessException {
        Object value = entity.getProperty(field.getName());
        if (value == null) {
            field.set(object, null);
            return;
        }
        if (fieldModel.isEnum()) {
            this.setEnumProperty(object, field, value);
            return;
        }
        if (fieldModel.isSaveAsJson()) {
            this.setJsonProperty(this.r, object, field, value);
            return;
        }
        if (fieldModel.isSaveAsLazyJson()) {
            this.setLazyJsonProperty(this.r, object, field, value);
            return;
        }
        if (fieldModel.isInt()) {
            this.setIntProperty(object, field, value);
            return;
        }
        if (fieldModel.isLong()) {
            this.setLongProperty(object, field, value);
            return;
        }
        if (fieldModel.isDate()) {
            this.setDateProperty(object, field, value);
            return;
        }
        if (fieldModel.isIdRef()) {
            this.setIdRefProperty(this.r, object, field, value);
            return;
        }
        if (fieldModel.isSaveAsText()) {
            this.setTextProperty(object, field, value);
            return;
        }
        if (fieldModel.isListOfIds()) {
            this.setListOfIdsProperty(object, field, value);
        }
        field.set(object, value);
    }

    private <T> void setIdRefProperty(Repository r, T object, Field field, Object value) throws IllegalAccessException {
        field.set(object, IdRef.parse((Repository)r, (HttpVerb)HttpVerb.GET, (String)((String)value)));
    }

    private <T> void setIntProperty(T object, Field field, Object value) throws IllegalAccessException {
        field.set(object, ((Double)value).intValue());
    }

    private <T> void setLongProperty(T object, Field field, Object value) throws IllegalAccessException {
        field.set(object, ((Double)value).longValue());
    }

    private <T> void setDateProperty(T object, Field field, Object value) throws IllegalAccessException {
        field.set(object, DateUtils.toTimestamp((String)((String)value)));
    }

    private <T> void setTextProperty(T object, Field field, Object value) throws IllegalAccessException {
        field.set(object, (String)value);
    }

    private <T> void setJsonProperty(Repository r, T object, Field field, Object value) throws IllegalAccessException {
        String json = (String)value;
        field.set(object, JsonUtils.from((Repository)r, (String)json, (Type)field.getGenericType()));
    }

    private <T> void setLazyJsonProperty(Repository r, T object, Field field, Object value) throws IllegalAccessException {
        String json = (String)value;
        Type type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        field.set(object, LazyJson.$create((Type)type, (String)json));
    }

    private <T> void setEnumProperty(T object, Field field, Object value) throws IllegalAccessException {
        field.set(object, Enum.valueOf(field.getType(), value.toString()));
    }

    private <T> void setListOfIdsProperty(T object, Field field, Object value) throws IllegalAccessException {
        List uris = (List)value;
        ArrayList<IdRef> ids = new ArrayList<IdRef>(uris.size());
        Class listGenericClazz = ReflectionUtils.getListGenericType((Type)field.getGenericType());
        for (String uri : uris) {
            ids.add(this.r.parseId(listGenericClazz, uri));
        }
        field.set(object, ids);
    }
}

