/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql.configuration;

import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;

public class DataSourceInfo {
    public static final String INIT_DATASOURCE = "jdbc/_yawp_init";
    private String name;
    private String driverClassName;
    private String url;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DataSource buildDatasource() {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(this.driverClassName);
        ds.setUrl(this.url);
        ds.setMaxTotal(50);
        return ds;
    }

    public DataSourceInfo getInitDatasource() {
        DataSourceInfo dsInit = new DataSourceInfo();
        dsInit.setName(INIT_DATASOURCE);
        dsInit.setDriverClassName(this.getDriverClassName());
        dsInit.setUrl(this.getInitDatabaseUrl());
        return dsInit;
    }

    public String getInitDatabaseUrl() {
        int endIndex = StringUtils.ordinalIndexOf((CharSequence)this.url, (CharSequence)"/", (int)3) + 1;
        return this.url.substring(0, endIndex) + "template1";
    }

    public String getDatabaseName() {
        int startIndex = StringUtils.ordinalIndexOf((CharSequence)this.url, (CharSequence)"/", (int)3) + 1;
        String databaseName = this.url.substring(startIndex);
        int endIndex = databaseName.indexOf("?");
        if (endIndex == -1) {
            return databaseName;
        }
        return databaseName.substring(0, endIndex);
    }
}

