/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql.configuration;

import io.yawp.commons.utils.Environment;
import io.yawp.commons.utils.ResourceFinder;
import io.yawp.driver.postgresql.configuration.DataSourceInfo;
import io.yawp.driver.postgresql.configuration.JettyConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class InitialContextSetup
implements InitialContextFactory {
    private static Context context;

    public static String envDataSourceName() {
        return String.format("jdbc/yawp_%s", Environment.getOrDefault());
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        return context;
    }

    public static void bind(String name, Object obj) {
        try {
            context.bind(name, obj);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unregister() {
        System.clearProperty("java.naming.factory.initial");
    }

    public static void configure(String resourceUri) {
        String path = InitialContextSetup.getPath(resourceUri);
        InitialContextSetup.configure(new File(path));
    }

    public static void configure(File file) {
        if (InitialContextSetup.alreadyRegisteredInitialContext()) {
            return;
        }
        JettyConfiguration configuration = JettyConfiguration.load(file.getAbsolutePath());
        DataSourceInfo dsInfo = configuration.getDatasourceInfo(Environment.getOrDefault());
        InitialContextSetup.bind("jdbc/_yawp_init", dsInfo.getInitDatasource().buildDatasource());
        InitialContextSetup.bind(InitialContextSetup.envDataSourceName(), dsInfo.buildDatasource());
    }

    private static boolean alreadyRegisteredInitialContext() {
        if (System.getProperty("java.naming.factory.initial") != null) {
            return true;
        }
        System.setProperty("java.naming.factory.initial", InitialContextSetup.class.getName());
        System.setProperty("java.naming.factory.url.pkgs", InitialContextSetup.class.getPackage().getName());
        return false;
    }

    private static String getPath(String resourceUri) {
        try {
            URL url = new ResourceFinder(new URL[0]).find(resourceUri);
            return url.getFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            context = new Xpto();
            context.bind("java:comp/env", (Object)context);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Xpto
    extends InitialContext {
        Map<String, Object> bindings = new HashMap<String, Object>();

        public Xpto() throws NamingException {
            super(true);
        }

        @Override
        public void bind(String name, Object obj) throws NamingException {
            this.bindings.put(name, obj);
        }

        @Override
        public Object lookup(String name) throws NamingException {
            return this.bindings.get(name);
        }
    }
}

