/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql.configuration;

import io.yawp.driver.postgresql.configuration.XmlLoader;
import io.yawp.servlet.EndpointServlet;
import java.util.List;

public class WebConfiguration {
    private String path;
    private String packagePrefix;

    public WebConfiguration(String path) {
        this.path = path;
        this.load();
    }

    private void load() {
        XmlLoader xml = new XmlLoader(this.path);
        List<XmlLoader> servlets = xml.find("/web-app/servlet");
        for (XmlLoader servletXml : servlets) {
            if (!this.isYawpServlet(servletXml)) continue;
            List<XmlLoader> initParams = servletXml.find("init-param");
            for (XmlLoader initParamXml : initParams) {
                XmlLoader paramValueXml;
                if (!this.isPackagePrefixParam(initParamXml) || (paramValueXml = this.findFirst(initParamXml, "param-value")) == null) continue;
                this.packagePrefix = paramValueXml.getTextContent();
                return;
            }
        }
    }

    private boolean isPackagePrefixParam(XmlLoader initParamXml) {
        XmlLoader paramNameXml = this.findFirst(initParamXml, "param-name");
        if (paramNameXml == null) {
            return false;
        }
        return paramNameXml.getTextContent().equals("packagePrefix");
    }

    private boolean isYawpServlet(XmlLoader servletXml) {
        XmlLoader servletClassXml = this.findFirst(servletXml, "servlet-class");
        if (servletClassXml == null) {
            return false;
        }
        return servletClassXml.getTextContent().equals(EndpointServlet.class.getName());
    }

    private XmlLoader findFirst(XmlLoader servletXml, String xpath) {
        List<XmlLoader> servletClazzes = servletXml.find(xpath);
        XmlLoader servlet = null;
        if (servletClazzes.size() != 0) {
            servlet = servletClazzes.get(0);
        }
        return servlet;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }
}

