/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql.datastore;

import io.yawp.driver.postgresql.datastore.DatastoreSqlRunner;
import io.yawp.driver.postgresql.datastore.Entity;
import io.yawp.driver.postgresql.datastore.EntityNotFoundException;
import io.yawp.driver.postgresql.datastore.FalsePredicateException;
import io.yawp.driver.postgresql.datastore.Key;
import io.yawp.driver.postgresql.datastore.Query;
import io.yawp.driver.postgresql.sql.ConnectionManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class Datastore {
    private static final String SQL_CREATE = "insert into :kind (key, properties) values (:key, :properties)";
    private static final String SQL_UPDATE = "update :kind set properties = :properties where key @> :key";
    private static final String SQL_GET = "select key, properties from :kind where key @> :key";
    private static final String SQL_EXISTS = "select exists(select 1 from :kind where key @> :key) as exists";
    private static final String SQL_DELETE = "delete from :kind where key @> :key";
    private ConnectionManager connectionManager;

    public static Datastore create(ConnectionManager connectionManager) {
        return new Datastore(connectionManager);
    }

    private Datastore(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Key put(Entity entity) {
        if (this.isNewEntity(entity)) {
            this.createEntity(entity);
        } else {
            this.updateEntity(entity);
        }
        return entity.getKey();
    }

    private void createEntity(Entity entity) {
        this.generateKey(entity);
        this.execute(SQL_CREATE, entity);
    }

    private void updateEntity(Entity entity) {
        this.execute(SQL_UPDATE, entity);
    }

    public Entity get(final Key key) throws EntityNotFoundException {
        DatastoreSqlRunner runner = new DatastoreSqlRunner(key.getKind(), SQL_GET){

            @Override
            public void bind() {
                this.bind("key", key);
            }

            @Override
            public Entity collectSingle(ResultSet rs) throws SQLException {
                return this.getEntity(rs);
            }
        };
        Entity entity = (Entity)this.connectionManager.executeQuery(runner);
        if (entity == null) {
            throw new EntityNotFoundException();
        }
        return entity;
    }

    public void delete(Key key) {
        this.execute(SQL_DELETE, key);
    }

    public List<Entity> query(Query query) throws FalsePredicateException {
        return query.execute(this.connectionManager);
    }

    private boolean isNewEntity(Entity entity) {
        Key key = entity.getKey();
        return key.isNew() || !this.existsEntityWithThisKey(key);
    }

    private boolean existsEntityWithThisKey(final Key key) {
        DatastoreSqlRunner runner = new DatastoreSqlRunner(key.getKind(), SQL_EXISTS){

            @Override
            public void bind() {
                this.bind("key", key);
            }

            @Override
            protected Object collectSingle(ResultSet rs) throws SQLException {
                return rs.getBoolean(1);
            }
        };
        return (Boolean)this.connectionManager.executeQuery(runner);
    }

    private void execute(String query, final Entity entity) {
        DatastoreSqlRunner runner = new DatastoreSqlRunner(entity.getKind(), query){

            @Override
            public void bind() {
                this.bind("key", entity.getKey());
                this.bind("properties", entity);
            }
        };
        this.connectionManager.execute(runner);
    }

    private void execute(String query, final Key key) {
        DatastoreSqlRunner runner = new DatastoreSqlRunner(key.getKind(), query){

            @Override
            public void bind() {
                this.bind("key", key);
            }
        };
        this.connectionManager.execute(runner);
    }

    private void generateKey(Entity entity) {
        Key key = entity.getKey();
        if (!key.isNew()) {
            return;
        }
        key.generate();
    }
}

