/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql.datastore;

import io.yawp.commons.utils.JsonUtils;
import io.yawp.driver.postgresql.datastore.Key;
import io.yawp.driver.postgresql.datastore.KeyFactory;
import java.util.HashMap;
import java.util.Map;

public class Entity {
    public static final String KEY_RESERVED_PROPERTY = "__key__";
    public static final String NORMALIZED_FIELD_PREFIX = "__";
    private Key key;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public Entity() {
    }

    public Entity(Key key) {
        this.key = key;
    }

    public Entity(String kind, Key parentKey) {
        this.key = KeyFactory.createKey(parentKey, kind);
    }

    public Entity(String kind) {
        this.key = KeyFactory.createKey(kind);
    }

    public Key getKey() {
        return this.key;
    }

    public String getKind() {
        return this.key.getKind();
    }

    public String serializeProperties() {
        return JsonUtils.to(this.properties);
    }

    public void deserializeProperties(String json) {
        this.properties = (Map)JsonUtils.from(null, (String)json, Map.class);
    }

    public void setProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    public void setUnindexedProperty(String property, Object value) {
        this.setProperty(property, value);
    }

    public Object getProperty(String property) {
        return this.properties.get(property);
    }
}

