/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql.datastore;

import io.yawp.commons.utils.JsonUtils;
import io.yawp.commons.utils.NameGenerator;

public class Key {
    private String ns;
    private Key parent;
    private String kind;
    private Long id;
    private String name;

    protected Key(String kind) {
        this.kind = kind;
    }

    protected Key(String ns, Key parent, String kind, String name, Long id) {
        this.ns = ns;
        this.parent = parent;
        this.kind = kind;
        this.name = name;
        this.id = id;
    }

    protected Key(Key parent, String kind, String name, Long id) {
        this(null, parent, kind, name, id);
    }

    protected String getNs() {
        return this.ns;
    }

    public Key getParent() {
        return this.parent;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public Long getId() {
        return this.id;
    }

    public String serialize() {
        return JsonUtils.to((Object)this);
    }

    public static Key deserialize(String json) {
        return (Key)JsonUtils.from(null, (String)json, Key.class);
    }

    public boolean isNew() {
        return this.name == null && this.id == null;
    }

    public void generate() {
        this.name = NameGenerator.generateFromUUID();
    }
}

