/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql.datastore;

import io.yawp.commons.utils.DateUtils;
import io.yawp.commons.utils.ReflectionUtils;
import io.yawp.driver.postgresql.IdRefToKey;
import io.yawp.driver.postgresql.datastore.DatastoreSqlRunner;
import io.yawp.driver.postgresql.datastore.Entity;
import io.yawp.driver.postgresql.datastore.FalsePredicateException;
import io.yawp.driver.postgresql.datastore.Key;
import io.yawp.driver.postgresql.datastore.NamespaceManager;
import io.yawp.driver.postgresql.sql.ConnectionManager;
import io.yawp.driver.postgresql.sql.SqlRunner;
import io.yawp.repository.IdRef;
import io.yawp.repository.Namespace;
import io.yawp.repository.Repository;
import io.yawp.repository.models.FieldModel;
import io.yawp.repository.query.QueryBuilder;
import io.yawp.repository.query.QueryOrder;
import io.yawp.repository.query.condition.BaseCondition;
import io.yawp.repository.query.condition.JoinedCondition;
import io.yawp.repository.query.condition.LogicalOperator;
import io.yawp.repository.query.condition.SimpleCondition;
import io.yawp.repository.query.condition.WhereOperator;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Query {
    private static final String SQL_PREFIX = "select key, properties from :kind";
    private Repository r;
    private QueryBuilder<?> builder;
    private boolean keysOnly;
    private Map<String, Object> whereBinds = new HashMap<String, Object>();

    public Query(QueryBuilder<?> builder, boolean keysOnly) {
        this.builder = builder;
        this.keysOnly = keysOnly;
        this.r = builder.getRepository();
    }

    public List<Entity> execute(ConnectionManager connectionManager) throws FalsePredicateException {
        List entities = (List)connectionManager.executeQuery(this.createRunner());
        this.setCursor(entities);
        return entities;
    }

    private void setCursor(List<Entity> entities) {
        if (entities.isEmpty()) {
            return;
        }
        long previousCursor = this.builder.getCursor() != null ? Long.valueOf(this.builder.getCursor()) : 0L;
        this.builder.setCursor(String.valueOf(previousCursor + (long)entities.size()));
    }

    private SqlRunner createRunner() throws FalsePredicateException {
        String sql = SQL_PREFIX + this.where() + this.order() + this.offset() + this.limit();
        return new DatastoreSqlRunner(this.getKind(), sql){

            @Override
            protected void bind() {
                for (String key : Query.this.whereBinds.keySet()) {
                    this.bind(key, Query.this.whereBinds.get(key));
                }
            }

            @Override
            protected Object collect(ResultSet rs) throws SQLException {
                return this.getEntities(rs);
            }
        };
    }

    private String getKind() {
        return this.builder.getModel().getKind();
    }

    private String where() throws FalsePredicateException {
        if (!this.hasAnyKindOfFilter()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" where ");
        sb.append(this.whereNamespace());
        if (this.hasPropertyFilter()) {
            sb.append(" and ");
            sb.append(this.where(this.builder.getCondition()));
        }
        if (this.hasAncestorFilter()) {
            sb.append(" and ");
            sb.append(this.whereAncestor());
        }
        return sb.toString();
    }

    private boolean hasAnyKindOfFilter() {
        return this.hasPropertyFilter() || this.hasAncestorFilter();
    }

    private boolean hasAncestorFilter() {
        return this.builder.getParentId() != null;
    }

    private boolean hasPropertyFilter() {
        return this.builder.getCondition() != null && this.builder.getCondition().hasPreFilter();
    }

    private String bindValue(Object value) {
        String placeHolder = "p" + (this.whereBinds.size() + 1);
        this.whereBinds.put(placeHolder, value);
        return placeHolder;
    }

    private String whereNamespace() {
        String ns = NamespaceManager.get();
        if (Namespace.GLOBAL.equals(ns)) {
            return this.whereGlobaleNamespace();
        }
        return this.whereNamespace(ns);
    }

    private String whereNamespace(String ns) {
        String placeHolder = this.bindValue(ns);
        return String.format("key->>'ns' = :%s", placeHolder);
    }

    private String whereGlobaleNamespace() {
        return "(key->'ns') is null";
    }

    private String whereAncestor() {
        IdRef parentId = this.builder.getParentId();
        String placeHolder = this.bindValue(IdRefToKey.toKey(this.r, parentId));
        return String.format("key%s = :%s", this.ancetorLink(parentId), placeHolder);
    }

    private String ancetorLink(IdRef<?> parentId) {
        StringBuilder sb = new StringBuilder();
        int ancestorNumber = this.getAncetorNumber(parentId);
        for (int i = -1; i < ancestorNumber; ++i) {
            sb.append("->'parent'");
        }
        String ancestorLink = sb.toString();
        return ancestorLink;
    }

    protected int getAncetorNumber(IdRef<?> parentId) {
        return this.builder.getModel().getAncestorNumber(parentId.getClazz());
    }

    private String where(BaseCondition condition) throws FalsePredicateException {
        if (condition instanceof SimpleCondition) {
            return this.simpleWhere((SimpleCondition)condition);
        }
        if (condition instanceof JoinedCondition) {
            return this.joinedWhere((JoinedCondition)condition);
        }
        throw new RuntimeException("Invalid condition class: " + condition.getClass());
    }

    private String simpleWhere(SimpleCondition condition) throws FalsePredicateException {
        String fieldName = condition.getField();
        Class clazz = this.builder.getModel().getClazz();
        Object whereValue = condition.getWhereValue();
        WhereOperator whereOperator = condition.getWhereOperator();
        String actualFieldName = this.getActualFieldName(fieldName, clazz);
        Object actualValue = this.getActualFieldValue(fieldName, clazz, whereValue);
        if (whereOperator == WhereOperator.IN) {
            if (this.listSize(whereValue) == 0) {
                throw new FalsePredicateException();
            }
            return this.whereCollectionValue(fieldName, actualFieldName, whereOperator, (Collection)actualValue);
        }
        return this.whereSingleValue(fieldName, actualFieldName, whereOperator, actualValue);
    }

    private String whereCollectionValue(String fieldName, String actualFieldName, WhereOperator whereOperator, Collection<?> collection) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("(");
        for (Object actualValue : collection) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            String placeHolder = this.bindValue(actualValue);
            sb.append(":");
            sb.append(placeHolder);
        }
        sb.append(")");
        return String.format("%s %s %s", this.propertyLink(fieldName, actualFieldName), this.filterOperatorAsText(whereOperator), sb.toString());
    }

    private String whereSingleValue(String fieldName, String actualFieldName, WhereOperator whereOperator, Object actualValue) {
        if (this.isNull(whereOperator, actualValue)) {
            return this.whereSingleValueIsNull(actualFieldName);
        }
        String placeHolder = this.bindValue(actualValue);
        if (this.isList(fieldName)) {
            return String.format(":%s %s ANY(ARRAY(select * from json_array_elements_text(to_json(%s))))", placeHolder, this.filterOperatorAsText(whereOperator.reverse()), this.propertyLink(fieldName, actualFieldName, false));
        }
        return String.format("%s %s :%s", this.propertyLink(fieldName, actualFieldName), this.filterOperatorAsText(whereOperator), placeHolder);
    }

    private String whereSingleValueIsNull(String actualFieldName) {
        return String.format("(properties->'%s') is null", actualFieldName);
    }

    private boolean isNull(WhereOperator whereOperator, Object actualValue) {
        return whereOperator.equals((Object)WhereOperator.EQUAL) && actualValue == null;
    }

    private boolean isList(String fieldName) {
        FieldModel fieldModel = this.builder.getModel().getFieldModel(fieldName);
        return fieldModel.isList();
    }

    private String propertyLink(String fieldName, String actualFieldName) {
        return this.propertyLink(fieldName, actualFieldName, true);
    }

    private String propertyLink(String fieldName, String actualFieldName, boolean scalar) {
        String retrieveOperator;
        FieldModel fieldModel = this.builder.getModel().getFieldModel(fieldName);
        String string = retrieveOperator = scalar ? ">>" : ">";
        if (fieldModel.isId()) {
            return "key";
        }
        if (fieldModel.isNumber()) {
            return String.format("cast(properties-%s'%s' as numeric)", retrieveOperator, actualFieldName);
        }
        return String.format("properties-%s'%s'", retrieveOperator, actualFieldName);
    }

    private String joinedWhere(JoinedCondition joinedCondition) throws FalsePredicateException {
        BaseCondition[] conditions = joinedCondition.getConditions();
        LogicalOperator logicalOperator = joinedCondition.getLogicalOperator();
        ArrayList<String> wheres = new ArrayList<String>();
        for (int i = 0; i < conditions.length; ++i) {
            try {
                BaseCondition condition = conditions[i];
                if (!condition.hasPreFilter()) continue;
                wheres.add(this.where(condition));
                continue;
            }
            catch (FalsePredicateException e) {
                if (logicalOperator != LogicalOperator.AND) continue;
                throw e;
            }
        }
        if (wheres.isEmpty()) {
            throw new FalsePredicateException();
        }
        if (wheres.size() == 1) {
            return (String)wheres.get(0);
        }
        return this.applyLogicalOperator(logicalOperator, wheres);
    }

    private String order() {
        if (CollectionUtils.isEmpty((Collection)this.builder.getPreOrders())) {
            return "";
        }
        Class clazz = this.builder.getModel().getClazz();
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        sb.append(" order by ");
        for (QueryOrder order : this.builder.getPreOrders()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(String.format("properties->>'%s'", this.getActualFieldName(order.getProperty(), clazz)));
            if (!order.isDesc()) continue;
            sb.append(" desc");
        }
        return sb.toString();
    }

    private String offset() {
        if (this.builder.getCursor() == null) {
            return "";
        }
        return String.format(" offset %s", this.builder.getCursor());
    }

    private String limit() {
        if (this.builder.getLimit() == null) {
            return "";
        }
        return String.format(" limit %d", this.builder.getLimit());
    }

    private String applyLogicalOperator(LogicalOperator logicalOperator, List<String> wheres) {
        boolean first = true;
        String operator = this.logicalOperatorAsText(logicalOperator);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (String where : wheres) {
            if (!first) {
                sb.append(operator);
            } else {
                first = false;
            }
            sb.append(where);
        }
        sb.append(")");
        return sb.toString();
    }

    private <T> String getActualFieldName(String fieldName, Class<T> clazz) {
        Field field = ReflectionUtils.getFieldRecursively(clazz, (String)fieldName);
        FieldModel fieldModel = new FieldModel(field);
        if (fieldModel.isId()) {
            return "__key__";
        }
        if (fieldModel.isIndexNormalizable()) {
            return "__" + fieldName;
        }
        return fieldName;
    }

    public <T> Object getActualFieldValue(String fieldName, Class<T> clazz, Object value) {
        Field field = ReflectionUtils.getFieldRecursively(clazz, (String)fieldName);
        FieldModel fieldModel = new FieldModel(field);
        if (fieldModel.isCollection(value)) {
            return this.getActualListFieldValue(fieldName, clazz, (Collection)value);
        }
        if (fieldModel.isId()) {
            return this.getActualKeyFieldValue(clazz, value);
        }
        if (fieldModel.isEnum(value)) {
            return value.toString();
        }
        if (fieldModel.isIndexNormalizable()) {
            return this.normalizeValue(value);
        }
        if (value instanceof IdRef) {
            return ((IdRef)value).getUri();
        }
        if (fieldModel.isDate() && value instanceof String) {
            return DateUtils.toTimestamp((String)((String)value));
        }
        return value;
    }

    private <T> Object getActualListFieldValue(String fieldName, Class<T> clazz, Collection<?> value) {
        Collection<?> objects = value;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object obj : objects) {
            values.add(this.getActualFieldValue(fieldName, clazz, obj));
        }
        return values;
    }

    private <T> Key getActualKeyFieldValue(Class<T> clazz, Object value) {
        IdRef id = (IdRef)value;
        return IdRefToKey.toKey(this.r, id);
    }

    private String logicalOperatorAsText(LogicalOperator logicalOperator) {
        String operator = null;
        if (logicalOperator == LogicalOperator.AND) {
            operator = " and ";
        } else if (logicalOperator == LogicalOperator.OR) {
            operator = " or ";
        } else {
            throw new RuntimeException("Invalid logical operator: " + logicalOperator);
        }
        return operator;
    }

    private String filterOperatorAsText(WhereOperator whereOperator) {
        switch (whereOperator) {
            case EQUAL: {
                return "=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUAL: {
                return ">=";
            }
            case IN: {
                return "in";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_OR_EQUAL: {
                return "<=";
            }
            case NOT_EQUAL: {
                return "<>";
            }
        }
        throw new RuntimeException("Invalid where operator: " + whereOperator);
    }

    private Object normalizeValue(Object o) {
        if (o == null) {
            return null;
        }
        if (!o.getClass().equals(String.class)) {
            return o;
        }
        return StringUtils.stripAccents((String)((String)o)).toLowerCase();
    }

    public int listSize(Object value) {
        if (value == null) {
            return 0;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        if (Collection.class.isAssignableFrom(value.getClass())) {
            return ((Collection)Collection.class.cast(value)).size();
        }
        if (Iterable.class.isAssignableFrom(value.getClass())) {
            return this.iterableSize(value);
        }
        throw new RuntimeException("Value used with operator 'in' is not an array or list.");
    }

    private int iterableSize(Object value) {
        Iterator it = ((Iterable)Iterable.class.cast(value)).iterator();
        int i = 0;
        while (it.hasNext()) {
            it.next();
            ++i;
        }
        return i;
    }
}

