/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql.sql;

import io.yawp.driver.postgresql.sql.ConnectionPool;
import io.yawp.driver.postgresql.sql.SqlRunner;
import java.sql.Connection;

public class ConnectionManager {
    private ConnectionPool connectionPool;
    private Connection connection;

    public ConnectionManager() {
        this.connectionPool = new ConnectionPool();
    }

    public ConnectionManager(String dataSourceName) {
        this.connectionPool = new ConnectionPool(dataSourceName);
    }

    private Connection getConnection() {
        if (this.isTransactionInProgress()) {
            return this.connection;
        }
        return this.connectionPool.connection();
    }

    private void returnToPool(Connection connection) {
        this.connectionPool.close(connection);
    }

    private boolean isTransactionInProgress() {
        return this.connection != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeQuery(SqlRunner runner) {
        Connection connection = this.getConnection();
        try {
            Object t = runner.executeQuery(connection);
            return t;
        }
        finally {
            if (!this.isTransactionInProgress()) {
                this.returnToPool(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SqlRunner runner) {
        Connection connection = this.getConnection();
        try {
            runner.execute(connection);
        }
        finally {
            if (!this.isTransactionInProgress()) {
                this.returnToPool(connection);
            }
        }
    }

    public void execute(String sql) {
        this.execute(new SqlRunner(sql));
    }

    public synchronized void beginTransaction() {
        if (this.isTransactionInProgress()) {
            throw new RuntimeException("Another transaction already in progress");
        }
        this.connection = this.connectionPool.connection(false);
    }

    public synchronized void rollback() {
        if (!this.isTransactionInProgress()) {
            throw new RuntimeException("No transaction already in progress");
        }
        this.connectionPool.rollbackAndClose(this.connection);
        this.connection = null;
    }

    public synchronized void commit() {
        if (!this.isTransactionInProgress()) {
            throw new RuntimeException("No transaction already in progress");
        }
        this.connectionPool.commitAndClose(this.connection);
        this.connection = null;
    }
}

