/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.driver.postgresql.sql;

import io.yawp.driver.postgresql.sql.PlaceHolder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.util.PGobject;

public class SqlRunner {
    protected String sql;
    protected Map<String, PlaceHolder> placeHolders = new HashMap<String, PlaceHolder>();

    public SqlRunner(String sql) {
        this.sql = sql;
        this.init();
    }

    private void init() {
        this.bind();
        this.parsePlaceHoldersIndexes();
        this.removePlaceHolders();
    }

    protected void bind() {
    }

    protected void prepare(PreparedStatement ps) throws SQLException {
    }

    protected Object collect(ResultSet rs) throws SQLException {
        throw new NotImplementedException();
    }

    protected Object collectSingle(ResultSet rs) throws SQLException {
        return null;
    }

    protected void bind(String placeHolderKey, PlaceHolder placeHolderObject) {
        this.placeHolders.put(":" + placeHolderKey, placeHolderObject);
    }

    protected void bind(String placeHolderKey, Object value) {
        this.bind(placeHolderKey, new PlaceHolder(value));
    }

    private void prepareInternal(PreparedStatement ps) throws SQLException {
        this.prepare(ps);
        this.prepareBinded(ps);
    }

    private void prepareBinded(PreparedStatement ps) throws SQLException {
        for (PlaceHolder placeHolder : this.placeHolders.values()) {
            placeHolder.setValue(ps);
        }
    }

    /*
     * Loose catch block
     */
    protected <T> T executeQuery(Connection connection) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Object object;
            ps = connection.prepareStatement(this.sql);
            this.prepareInternal(ps);
            rs = ps.executeQuery();
            try {
                object = this.collect(rs);
            }
            catch (NotImplementedException e) {
                block23: {
                    if (rs.next()) break block23;
                    T t = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException e2) {
                        throw new RuntimeException(e2);
                    }
                    return t;
                }
                Object object2 = this.collectSingle(rs);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException e3) {
                    throw new RuntimeException(e3);
                }
                return (T)object2;
                catch (SQLException e4) {
                    System.out.println("problem with sql: " + this.sql);
                    throw new RuntimeException(e4);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            return (T)object;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void execute(Connection connection) {
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(this.sql);
            this.prepareInternal(ps);
            ps.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void parsePlaceHoldersIndexes() {
        Pattern pattern = Pattern.compile("\\:\\w+");
        Matcher matcher = pattern.matcher(this.sql);
        int index = 1;
        while (matcher.find()) {
            String key = matcher.group();
            PlaceHolder placeHolder = this.placeHolders.get(key);
            placeHolder.addIndex(index++);
        }
    }

    private void removePlaceHolders() {
        for (String placeHolderKey : this.placeHolders.keySet()) {
            this.sql = this.sql.replaceAll(placeHolderKey, "?");
        }
    }

    protected final PGobject createJsonObject(String json) {
        try {
            PGobject jsonObject = new PGobject();
            jsonObject.setType("jsonb");
            jsonObject.setValue(json);
            return jsonObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class NotImplementedException
    extends RuntimeException {
        private NotImplementedException() {
        }
    }
}

